/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.aopalliance.aop.Advice;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.kafka.listener.ConsumerProperties;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.kafka.support.micrometer.KafkaListenerObservationConvention;
import org.springframework.kafka.transaction.KafkaAwareTransactionManager;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ContainerProperties
extends ConsumerProperties {
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 10000L;
    public static final int DEFAULT_MONITOR_INTERVAL = 30;
    public static final float DEFAULT_NO_POLL_THRESHOLD = 3.0f;
    private static final Duration DEFAULT_CONSUMER_START_TIMEOUT = Duration.ofSeconds(30L);
    private static final int DEFAULT_ACK_TIME = 5000;
    private static final double DEFAULT_IDLE_BEFORE_DATA_MULTIPLIER = 5.0;
    private static final long ONE_HUNDRED = 100L;
    private static final Duration DEFAULT_PAUSED_POLL_TIMEOUT = Duration.ofMillis(100L);
    private final Map<String, String> micrometerTags = new HashMap<String, String>();
    private final List<Advice> adviceChain = new ArrayList<Advice>();
    private @Nullable Function<ConsumerRecord<?, ?>, Map<String, String>> micrometerTagsProvider;
    private AckMode ackMode = AckMode.BATCH;
    private int ackCount = 1;
    private long ackTime = 5000L;
    private @Nullable Object messageListener;
    private @Nullable AsyncTaskExecutor listenerTaskExecutor;
    private long shutdownTimeout = 10000L;
    private @Nullable Long idleEventInterval;
    private @Nullable Long idlePartitionEventInterval;
    private double idleBeforeDataMultiplier = 5.0;
    @Deprecated(since="3.2")
    private @Nullable PlatformTransactionManager transactionManager;
    private @Nullable KafkaAwareTransactionManager<?, ?> kafkaAwareTransactionManager;
    private boolean batchRecoverAfterRollback = false;
    private int monitorInterval = 30;
    private @Nullable TaskScheduler scheduler;
    private float noPollThreshold = 3.0f;
    private boolean logContainerConfig;
    private boolean missingTopicsFatal = false;
    private long idleBetweenPolls;
    private boolean micrometerEnabled = true;
    private boolean observationEnabled;
    private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
    private Duration consumerStartTimeout = DEFAULT_CONSUMER_START_TIMEOUT;
    private @Nullable Boolean subBatchPerPartition;
    private AssignmentCommitOption assignmentCommitOption = AssignmentCommitOption.LATEST_ONLY_NO_TX;
    private boolean deliveryAttemptHeader;
    private EOSMode eosMode = EOSMode.V2;
    private @Nullable TransactionDefinition transactionDefinition;
    private boolean stopContainerWhenFenced;
    private boolean stopImmediate;
    private boolean asyncAcks;
    private boolean pauseImmediate;
    private @Nullable KafkaListenerObservationConvention observationConvention;
    private Duration pollTimeoutWhilePaused = DEFAULT_PAUSED_POLL_TIMEOUT;
    private boolean restartAfterAuthExceptions;
    private boolean recordObservationsInBatch;

    public ContainerProperties(String ... topics) {
        super(topics);
    }

    public ContainerProperties(@Nullable Pattern topicPattern) {
        super(topicPattern);
    }

    public ContainerProperties(TopicPartitionOffset ... topicPartitions) {
        super(topicPartitions);
    }

    public void setMessageListener(Object messageListener) {
        this.messageListener = messageListener;
        this.adviseListenerIfNeeded();
    }

    public void setAckMode(AckMode ackMode) {
        Assert.notNull((Object)((Object)ackMode), (String)"'ackMode' cannot be null");
        this.ackMode = ackMode;
    }

    public void setAckCount(int count) {
        Assert.state((count > 0 ? 1 : 0) != 0, (String)"'ackCount' must be > 0");
        this.ackCount = count;
    }

    public void setAckTime(long ackTime) {
        Assert.state((ackTime > 0L ? 1 : 0) != 0, (String)"'ackTime' must be > 0");
        this.ackTime = ackTime;
    }

    public void setListenerTaskExecutor(@Nullable AsyncTaskExecutor listenerTaskExecutor) {
        this.listenerTaskExecutor = listenerTaskExecutor;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    @Override
    public void setSyncCommitTimeout(@Nullable Duration syncCommitTimeout) {
        super.setSyncCommitTimeout(syncCommitTimeout);
    }

    public void setIdleEventInterval(@Nullable Long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    public void setIdleBeforeDataMultiplier(double idleBeforeDataMultiplier) {
        this.idleBeforeDataMultiplier = idleBeforeDataMultiplier;
    }

    public void setIdlePartitionEventInterval(@Nullable Long idlePartitionEventInterval) {
        this.idlePartitionEventInterval = idlePartitionEventInterval;
    }

    public AckMode getAckMode() {
        return this.ackMode;
    }

    public int getAckCount() {
        return this.ackCount;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public @Nullable Object getMessageListener() {
        return this.messageListener;
    }

    public @Nullable AsyncTaskExecutor getListenerTaskExecutor() {
        return this.listenerTaskExecutor;
    }

    public long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public @Nullable Long getIdleEventInterval() {
        return this.idleEventInterval;
    }

    public double getIdleBeforeDataMultiplier() {
        return this.idleBeforeDataMultiplier;
    }

    public @Nullable Long getIdlePartitionEventInterval() {
        return this.idlePartitionEventInterval;
    }

    @Deprecated(since="3.2", forRemoval=true)
    public @Nullable PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Deprecated(since="3.2", forRemoval=true)
    public void setTransactionManager(@Nullable PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public @Nullable KafkaAwareTransactionManager<?, ?> getKafkaAwareTransactionManager() {
        return this.kafkaAwareTransactionManager;
    }

    public void setKafkaAwareTransactionManager(@Nullable KafkaAwareTransactionManager<?, ?> kafkaAwareTransactionManager) {
        this.kafkaAwareTransactionManager = kafkaAwareTransactionManager;
    }

    public boolean isBatchRecoverAfterRollback() {
        return this.batchRecoverAfterRollback;
    }

    public void setBatchRecoverAfterRollback(boolean batchRecoverAfterRollback) {
        this.batchRecoverAfterRollback = batchRecoverAfterRollback;
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public @Nullable TaskScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(@Nullable TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public float getNoPollThreshold() {
        return this.noPollThreshold;
    }

    public void setNoPollThreshold(float noPollThreshold) {
        this.noPollThreshold = noPollThreshold;
    }

    public boolean isLogContainerConfig() {
        return this.logContainerConfig;
    }

    public void setLogContainerConfig(boolean logContainerConfig) {
        this.logContainerConfig = logContainerConfig;
    }

    public boolean isMissingTopicsFatal() {
        return this.missingTopicsFatal;
    }

    public void setMissingTopicsFatal(boolean missingTopicsFatal) {
        this.missingTopicsFatal = missingTopicsFatal;
    }

    public void setIdleBetweenPolls(long idleBetweenPolls) {
        this.idleBetweenPolls = idleBetweenPolls;
    }

    public long getIdleBetweenPolls() {
        return this.idleBetweenPolls;
    }

    public boolean isMicrometerEnabled() {
        return this.micrometerEnabled;
    }

    public void setMicrometerEnabled(boolean micrometerEnabled) {
        this.micrometerEnabled = micrometerEnabled;
    }

    public boolean isObservationEnabled() {
        return this.observationEnabled;
    }

    public void setObservationEnabled(boolean observationEnabled) {
        this.observationEnabled = observationEnabled;
    }

    public ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }

    public void setObservationRegistry(ObservationRegistry observationRegistry) {
        Assert.notNull((Object)observationRegistry, (String)"'observationRegistry' must not be null");
        this.observationRegistry = observationRegistry;
    }

    public void setMicrometerTags(Map<String, String> tags) {
        if (tags != null) {
            this.micrometerTags.putAll(tags);
        }
    }

    public Map<String, String> getMicrometerTags() {
        return Collections.unmodifiableMap(this.micrometerTags);
    }

    public void setMicrometerTagsProvider(@Nullable Function<ConsumerRecord<?, ?>, Map<String, String>> micrometerTagsProvider) {
        this.micrometerTagsProvider = micrometerTagsProvider;
    }

    public @Nullable Function<ConsumerRecord<?, ?>, Map<String, String>> getMicrometerTagsProvider() {
        return this.micrometerTagsProvider;
    }

    public Duration getConsumerStartTimeout() {
        return this.consumerStartTimeout;
    }

    public void setConsumerStartTimeout(Duration consumerStartTimeout) {
        Assert.notNull((Object)consumerStartTimeout, (String)"'consumerStartTimout' cannot be null");
        this.consumerStartTimeout = consumerStartTimeout;
    }

    public boolean isSubBatchPerPartition() {
        return this.subBatchPerPartition != null && this.subBatchPerPartition != false;
    }

    public @Nullable Boolean getSubBatchPerPartition() {
        return this.subBatchPerPartition;
    }

    public void setSubBatchPerPartition(@Nullable Boolean subBatchPerPartition) {
        this.subBatchPerPartition = subBatchPerPartition;
    }

    public AssignmentCommitOption getAssignmentCommitOption() {
        return this.assignmentCommitOption;
    }

    public void setAssignmentCommitOption(AssignmentCommitOption assignmentCommitOption) {
        Assert.notNull((Object)((Object)assignmentCommitOption), (String)"'assignmentCommitOption' cannot be null");
        this.assignmentCommitOption = assignmentCommitOption;
    }

    public boolean isDeliveryAttemptHeader() {
        return this.deliveryAttemptHeader;
    }

    public void setDeliveryAttemptHeader(boolean deliveryAttemptHeader) {
        this.deliveryAttemptHeader = deliveryAttemptHeader;
    }

    public EOSMode getEosMode() {
        return this.eosMode;
    }

    public void setEosMode(EOSMode eosMode) {
        Assert.notNull((Object)((Object)eosMode), (String)"'eosMode' cannot be null");
        this.eosMode = eosMode;
    }

    public @Nullable TransactionDefinition getTransactionDefinition() {
        return this.transactionDefinition;
    }

    public void setTransactionDefinition(@Nullable TransactionDefinition transactionDefinition) {
        this.transactionDefinition = transactionDefinition;
    }

    public Advice[] getAdviceChain() {
        return this.adviceChain.toArray(new Advice[0]);
    }

    public void setAdviceChain(Advice ... adviceChain) {
        Assert.notNull((Object)adviceChain, (String)"'adviceChain' cannot be null");
        Assert.noNullElements((Object[])adviceChain, (String)"'adviceChain' cannot have null elements");
        this.adviceChain.clear();
        this.adviceChain.addAll(Arrays.asList(adviceChain));
        if (this.messageListener != null) {
            this.adviseListenerIfNeeded();
        }
    }

    public boolean isStopContainerWhenFenced() {
        return this.stopContainerWhenFenced;
    }

    public void setStopContainerWhenFenced(boolean stopContainerWhenFenced) {
        this.stopContainerWhenFenced = stopContainerWhenFenced;
    }

    public boolean isStopImmediate() {
        return this.stopImmediate;
    }

    public void setStopImmediate(boolean stopImmediate) {
        this.stopImmediate = stopImmediate;
    }

    public boolean isAsyncAcks() {
        return this.asyncAcks;
    }

    public void setAsyncAcks(boolean asyncAcks) {
        this.asyncAcks = asyncAcks;
    }

    public boolean isPauseImmediate() {
        return this.pauseImmediate;
    }

    public void setPauseImmediate(boolean pauseImmediate) {
        this.pauseImmediate = pauseImmediate;
    }

    private void adviseListenerIfNeeded() {
        if (!CollectionUtils.isEmpty(this.adviceChain)) {
            if (AopUtils.isAopProxy((Object)this.messageListener)) {
                Advised advised = (Advised)this.messageListener;
                this.adviceChain.forEach(arg_0 -> ((Advised)advised).removeAdvice(arg_0));
                this.adviceChain.forEach(arg_0 -> ((Advised)advised).addAdvice(arg_0));
            } else if (this.messageListener != null) {
                ProxyFactory pf = new ProxyFactory(this.messageListener);
                this.adviceChain.forEach(arg_0 -> ((ProxyFactory)pf).addAdvice(arg_0));
                this.messageListener = pf.getProxy();
            }
        }
    }

    public @Nullable KafkaListenerObservationConvention getObservationConvention() {
        return this.observationConvention;
    }

    public void setObservationConvention(KafkaListenerObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }

    public Duration getPollTimeoutWhilePaused() {
        return this.pollTimeoutWhilePaused;
    }

    public void setPollTimeoutWhilePaused(Duration pollTimeoutWhilePaused) {
        Assert.notNull((Object)pollTimeoutWhilePaused, (String)"'pollTimeoutWhilePaused' cannot be null");
        this.pollTimeoutWhilePaused = pollTimeoutWhilePaused;
    }

    public boolean isRestartAfterAuthExceptions() {
        return this.restartAfterAuthExceptions;
    }

    public void setRestartAfterAuthExceptions(boolean restartAfterAuthExceptions) {
        this.restartAfterAuthExceptions = restartAfterAuthExceptions;
    }

    public boolean isRecordObservationsInBatch() {
        return this.recordObservationsInBatch;
    }

    public void setRecordObservationsInBatch(boolean recordObservationsInBatch) {
        this.recordObservationsInBatch = recordObservationsInBatch;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ContainerProperties [");
        sb.append(this.renderProperties());
        this.appendProperty(sb, "ackMode", (Object)this.ackMode);
        this.appendProperty(sb, "ackCount", this.ackCount);
        this.appendProperty(sb, "ackTime", this.ackTime);
        this.appendProperty(sb, "consumerStartTimeout", this.consumerStartTimeout);
        this.appendProperty(sb, "shutdownTimeout", this.shutdownTimeout);
        this.appendProperty(sb, "messageListener", this.messageListener);
        this.appendProperty(sb, "listenerTaskExecutor", this.listenerTaskExecutor);
        this.appendEnabledProperty(sb, "idleEventInterval", this.idleEventInterval);
        this.appendEnabledProperty(sb, "idlePartitionEventInterval", this.idlePartitionEventInterval);
        this.appendProperty(sb, "transactionManager", this.transactionManager);
        this.appendProperty(sb, "kafkaAwareTransactionManager", this.kafkaAwareTransactionManager);
        this.appendProperty(sb, "transactionDefinition", this.transactionDefinition);
        this.appendProperty(sb, "monitorInterval", this.monitorInterval);
        this.appendProperty(sb, "scheduler", this.scheduler);
        this.appendProperty(sb, "noPollThreshold", Float.valueOf(this.noPollThreshold));
        this.appendProperty(sb, "pauseImmediate", this.pauseImmediate);
        this.appendProperty(sb, "stopImmediate", this.stopImmediate);
        this.appendProperty(sb, "stopContainerWhenFenced", this.stopContainerWhenFenced);
        this.appendProperty(sb, "asyncAcks", this.asyncAcks);
        this.appendProperty(sb, "pollTimeoutWhilePaused", this.pollTimeoutWhilePaused);
        this.appendProperty(sb, "subBatchPerPartition", this.subBatchPerPartition);
        this.appendProperty(sb, "assignmentCommitOption", (Object)this.assignmentCommitOption);
        this.appendProperty(sb, "idleBetweenPolls", this.idleBetweenPolls);
        this.appendProperty(sb, "deliveryAttemptHeader", this.deliveryAttemptHeader);
        this.appendProperty(sb, "batchRecoverAfterRollback", this.batchRecoverAfterRollback);
        this.appendProperty(sb, "eosMode", (Object)this.eosMode);
        this.appendProperty(sb, "logContainerConfig", this.logContainerConfig);
        this.appendProperty(sb, "missingTopicsFatal", this.missingTopicsFatal);
        this.appendProperty(sb, "restartAfterAuthExceptions", this.restartAfterAuthExceptions);
        this.appendProperty(sb, "micrometerEnabled", this.micrometerEnabled);
        this.appendProperty(sb, "observationEnabled", this.observationEnabled);
        this.appendProperty(sb, "recordObservationsInBatch", this.recordObservationsInBatch);
        this.appendProperty(sb, "observationConvention", this.observationConvention);
        this.appendProperty(sb, "observationRegistry", this.observationRegistry);
        this.appendProperty(sb, "idleBeforeDataMultiplier", this.idleBeforeDataMultiplier);
        sb.append("\n]");
        return sb.toString();
    }

    private void appendProperty(StringBuilder sb, String name, @Nullable Object value) {
        if (value != null) {
            sb.append("\n ").append(name).append("=").append(value);
        }
    }

    private void appendEnabledProperty(StringBuilder sb, String name, @Nullable Object value) {
        sb.append("\n ").append(name).append("=").append(value == null ? "not enabled" : value);
    }

    public static enum AckMode {
        RECORD,
        BATCH,
        TIME,
        COUNT,
        COUNT_TIME,
        MANUAL,
        MANUAL_IMMEDIATE;

    }

    public static enum AssignmentCommitOption {
        ALWAYS,
        NEVER,
        LATEST_ONLY,
        LATEST_ONLY_NO_TX;

    }

    public static enum EOSMode {
        V2;

    }
}

