/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.springframework.modulith.aptk.tools.TypeMirrorWrapper;
import org.springframework.modulith.aptk.tools.wrapper.ExecutableElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.TypeElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.TypeParameterElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.VariableElementWrapper;

public class InterfaceUtils {
    public static Set<ExecutableElementWrapper> getMethodsToImplement(TypeElementWrapper typeElementWrapper, TypeMirrorWrapper ... typeArgumentsToReplace) {
        if (!typeElementWrapper.isInterface()) {
            return Collections.emptySet();
        }
        HashSet<ExecutableElementWrapper> result = new HashSet<ExecutableElementWrapper>();
        Map<String, TypeMirrorWrapper> typeVarMappings = InterfaceUtils.mapTypeVars(typeElementWrapper, typeArgumentsToReplace);
        result.addAll(typeElementWrapper.getMethods(new Modifier[0]).stream().map(e -> new TVExecutableElementWrapper((ExecutableElement)e.unwrap(), typeVarMappings)).collect(Collectors.toList()));
        for (TypeMirrorWrapper parentInterface : typeElementWrapper.getInterfaces()) {
            result.addAll(InterfaceUtils.getMethodsToImplement(parentInterface.getTypeElement().get(), InterfaceUtils.getTypeArgumentsForParentInterface(parentInterface, typeVarMappings)));
        }
        return result;
    }

    public static List<TypeMirrorWrapper> getResolvedTypeArgumentOfSuperTypeOrInterface(TypeElementWrapper typeElementWrapper, TypeMirrorWrapper interfaceOrSupertypeToSearch, TypeMirrorWrapper ... typeArgumentsToReplace) {
        ArrayList<TypeMirrorWrapper> result = new ArrayList<TypeMirrorWrapper>();
        Map<String, TypeMirrorWrapper> typeVarMappings = InterfaceUtils.mapTypeVars(typeElementWrapper, typeArgumentsToReplace);
        Optional<TypeElementWrapper> superclassTEW = typeElementWrapper.getSuperclass().getTypeElement();
        if (superclassTEW.isPresent()) {
            if (superclassTEW.get().asType().erasure().equals(interfaceOrSupertypeToSearch.erasure())) {
                for (TypeMirrorWrapper typeArgument : typeElementWrapper.getSuperclass().getWrappedTypeArguments()) {
                    if (typeArgument.isTypeVar()) {
                        result.add(typeVarMappings.get(typeArgument.toString()));
                        continue;
                    }
                    result.add(typeArgument);
                }
            } else {
                result.addAll(InterfaceUtils.getResolvedTypeArgumentOfSuperTypeOrInterface(superclassTEW.get(), interfaceOrSupertypeToSearch, InterfaceUtils.getTypeArgumentsForParentInterface(typeElementWrapper.getSuperclass(), typeVarMappings)));
            }
        }
        for (TypeMirrorWrapper parentInterface : typeElementWrapper.getInterfaces()) {
            if (interfaceOrSupertypeToSearch.getQualifiedName().equals(parentInterface.getQualifiedName())) {
                for (TypeMirrorWrapper typeArgument : parentInterface.getWrappedTypeArguments()) {
                    if (typeArgument.isTypeVar()) {
                        result.add(typeVarMappings.get(typeArgument.toString()));
                        continue;
                    }
                    result.add(typeArgument);
                }
                continue;
            }
            result.addAll(InterfaceUtils.getResolvedTypeArgumentOfSuperTypeOrInterface(parentInterface.getTypeElement().get(), interfaceOrSupertypeToSearch, InterfaceUtils.getTypeArgumentsForParentInterface(parentInterface, typeVarMappings)));
        }
        return result;
    }

    static Map<String, TypeMirrorWrapper> mapTypeVars(TypeElementWrapper interfaceTypeElement, TypeMirrorWrapper ... interfacesTypeParameterTypes) {
        HashMap<String, TypeMirrorWrapper> map = new HashMap<String, TypeMirrorWrapper>();
        int i = 0;
        for (TypeParameterElementWrapper typeParameterElementWrapper : interfaceTypeElement.getTypeParameters()) {
            map.put(typeParameterElementWrapper.asType().getTypeVar().toString(), i < interfacesTypeParameterTypes.length ? interfacesTypeParameterTypes[i] : typeParameterElementWrapper.asType());
            ++i;
        }
        return map;
    }

    static TypeMirrorWrapper[] getTypeArgumentsForParentInterface(TypeMirrorWrapper parentInterface, Map<String, TypeMirrorWrapper> typeVarMappings) {
        ArrayList<TypeMirrorWrapper> result = new ArrayList<TypeMirrorWrapper>();
        if (parentInterface.hasTypeArguments()) {
            for (TypeMirrorWrapper typeMirrorWrapper : parentInterface.getWrappedTypeArguments()) {
                if (typeMirrorWrapper.isTypeVar() && typeVarMappings.containsKey(typeMirrorWrapper.getTypeVar().toString())) {
                    result.add(typeVarMappings.get(typeMirrorWrapper.getTypeVar().toString()));
                    continue;
                }
                result.add(typeMirrorWrapper);
            }
        }
        return result.toArray(new TypeMirrorWrapper[0]);
    }

    static class TVExecutableElementWrapper
    extends ExecutableElementWrapper {
        private final Map<String, TypeMirrorWrapper> typeVarMap;

        TVExecutableElementWrapper(ExecutableElement element, Map<String, TypeMirrorWrapper> typeVarMap) {
            super(element);
            this.typeVarMap = typeVarMap;
        }

        @Override
        public String getMethodSignature() {
            StringBuilder builder = new StringBuilder();
            if (!this.getTypeParameters().isEmpty()) {
                builder.append("<");
                builder.append(this.getTypeParameters().stream().map(tp -> tp.getSimpleName() + " extends " + tp.getBounds().stream().map(tm -> new TVTypeMirrorWrapper(tm.unwrap(), this.typeVarMap).getTypeDeclaration()).collect(Collectors.joining(" & "))).collect(Collectors.joining(", ")));
                builder.append("> ");
            }
            builder.append(this.getReturnType().getTypeDeclaration()).append(" ").append(this.getSimpleName());
            builder.append("(");
            if (this.isVarArgs()) {
                if (this.getParameters().size() > 1) {
                    List<VariableElementWrapper> nonVarargParameters = this.getParameters().subList(0, this.getParameters().size() - 1);
                    builder.append(nonVarargParameters.stream().map(element -> new TVTypeMirrorWrapper(element.asType().unwrap(), this.typeVarMap).getTypeDeclaration() + " " + element.getSimpleName()).collect(Collectors.joining(", ")));
                    builder.append(", ");
                }
                VariableElementWrapper lastVariableElement = this.getParameters().get(this.getParameters().size() - 1);
                builder.append(lastVariableElement.asType().getWrappedComponentType().getTypeDeclaration()).append("... ").append(lastVariableElement.getSimpleName());
            } else {
                builder.append(((ExecutableElement)this.element).getParameters().stream().map(element -> new TVTypeMirrorWrapper(element.asType(), this.typeVarMap).getTypeDeclaration() + " " + element.getSimpleName()).collect(Collectors.joining(", ")));
            }
            builder.append(")");
            if (!this.getThrownTypes().isEmpty()) {
                builder.append(" throws ");
                builder.append(this.getThrownTypes().stream().map(TypeMirrorWrapper::getSimpleName).collect(Collectors.joining(", ")));
            }
            return builder.toString();
        }

        @Override
        public Set<String> getImports() {
            return super.getImports();
        }

        @Override
        public TypeMirrorWrapper getReturnType() {
            return new TVTypeMirrorWrapper(super.getReturnType().unwrap(), this.typeVarMap);
        }

        @Override
        public List<VariableElementWrapper> getParameters() {
            return super.getParameters().stream().map(e -> new TVVariableElementWrapper((VariableElement)e.unwrap(), this.typeVarMap)).collect(Collectors.toList());
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            for (VariableElementWrapper parameter : this.getParameters()) {
                hashCode += parameter.asType().getTypeDeclaration().hashCode();
            }
            return this.getSimpleName().hashCode() + hashCode;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof TVExecutableElementWrapper)) {
                return false;
            }
            ExecutableElementWrapper otherObj = (ExecutableElementWrapper)obj;
            if (!this.getSimpleName().equals(otherObj.getSimpleName())) {
                return false;
            }
            if (this.getParameters().size() != otherObj.getParameters().size()) {
                return false;
            }
            for (int i = 0; i < this.getParameters().size(); ++i) {
                if (this.getParameters().get(i).asType().getTypeDeclaration().equals(otherObj.getParameters().get(i).asType().getTypeDeclaration())) continue;
                return false;
            }
            return true;
        }
    }

    static class TVVariableElementWrapper
    extends VariableElementWrapper {
        private final Map<String, TypeMirrorWrapper> typeVarMap;

        TVVariableElementWrapper(VariableElement element, Map<String, TypeMirrorWrapper> typeVarMap) {
            super(element);
            this.typeVarMap = typeVarMap;
        }

        @Override
        public TypeMirrorWrapper asType() {
            return new TVTypeMirrorWrapper(super.asType().unwrap(), this.typeVarMap);
        }
    }

    public static class TVTypeMirrorWrapper
    extends TypeMirrorWrapper {
        private final TypeMirrorWrapper originalTypeMirror;
        private final Map<String, TypeMirrorWrapper> typeVarMap;

        TVTypeMirrorWrapper(TypeMirror typeMirror, Map<String, TypeMirrorWrapper> typeVarMap) {
            super(TVTypeMirrorWrapper.getTypeMirrorWithReplacedTypeVars(typeMirror, typeVarMap).unwrap());
            this.originalTypeMirror = TypeMirrorWrapper.wrap(typeMirror);
            this.typeVarMap = typeVarMap;
        }

        static TypeMirrorWrapper getTypeMirrorWithReplacedTypeVars(TypeMirror typeMirror, Map<String, TypeMirrorWrapper> typeVarMap) {
            TypeMirrorWrapper typeMirrorWrapper = TypeMirrorWrapper.wrap(typeMirror);
            if (typeMirrorWrapper.isTypeVar() && typeVarMap.containsKey(typeMirrorWrapper.getTypeVar().toString())) {
                return typeVarMap.get(typeMirrorWrapper.getTypeVar().toString());
            }
            return typeMirrorWrapper;
        }

        @Override
        public String getTypeDeclaration() {
            if (this.getKind() == TypeKind.VOID) {
                return "void";
            }
            if (this.isPrimitive()) {
                return this.toString();
            }
            if (this.isArray()) {
                return TVTypeMirrorWrapper.getTypeDeclaration(this.getComponentType()) + "[]";
            }
            if (this.isTypeVar()) {
                return this.toString();
            }
            if (this.isDeclared()) {
                return this.getSimpleName() + (this.hasTypeArguments() ? "<" + this.getWrappedTypeArguments().stream().map(e -> new TVTypeMirrorWrapper(e.unwrap(), this.typeVarMap)).map(e -> e.getTypeDeclaration()).collect(Collectors.joining(", ")) + ">" : "");
            }
            if (this.isWildcardType()) {
                WildcardType wildcardType = this.getWildcardType();
                if (wildcardType.getSuperBound() != null) {
                    return "? super " + new TVTypeMirrorWrapper(wildcardType.getSuperBound(), this.typeVarMap).getTypeDeclaration();
                }
                if (wildcardType.getExtendsBound() != null) {
                    return "? extends " + new TVTypeMirrorWrapper(wildcardType.getExtendsBound(), this.typeVarMap).getTypeDeclaration();
                }
                return "?";
            }
            return this.toString();
        }
    }
}

