/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.docs.util;

import java.io.File;
import java.util.Optional;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class BuildSystemUtils {
    public static String getTarget(String path) {
        Assert.notNull((Object)path, (String)"Path must not be null!");
        return BuildSystemUtils.getTargetFolder() + (String)(path.startsWith("/") ? path : "/" + path);
    }

    public static Optional<Resource> getTargetResource(String path) {
        return Optional.of(new FileSystemResource(BuildSystemUtils.getTarget(path))).filter(Resource::exists);
    }

    public static String getTestTarget() {
        return BuildSystemUtils.isMaven() ? "target/test-classes" : "build/classes/java/test";
    }

    private static String getTargetFolder() {
        return BuildSystemUtils.isMaven() ? "target" : "build";
    }

    private static boolean isMaven() {
        return new File("pom.xml").exists();
    }
}

