/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.apt;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.springframework.boot.json.JsonWriter;
import org.springframework.lang.Nullable;
import org.springframework.modulith.aptk.tools.ElementUtils;
import org.springframework.modulith.aptk.tools.wrapper.ElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.ExecutableElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.TypeElementWrapper;
import org.springframework.modulith.docs.metadata.MethodMetadata;
import org.springframework.modulith.docs.metadata.TypeMetadata;
import org.springframework.modulith.docs.util.BuildSystemUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SpringModulithProcessor
implements Processor {
    private static final Collection<String> JAVADOC_TAGS = Set.of("@param", "@return", "@author", "@since", "@see");
    static final String JSON_LOCATION = BuildSystemUtils.getTarget("generated-spring-modulith/javadoc.json");
    private Elements elements;
    private Messager messager;
    private File javadocJson;
    private boolean testExecution;
    private Set<TypeMetadata> metadata = new HashSet<TypeMetadata>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.emptyList();
    }

    @Override
    public void init(ProcessingEnvironment environment) {
        this.elements = environment.getElementUtils();
        this.messager = environment.getMessager();
        this.javadocJson = SpringModulithProcessor.getAptOutputFolder(environment).resolve(JSON_LOCATION).toFile();
        try {
            String path = environment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/spring-modulith", new Element[0]).toUri().toString();
            if (path.contains(BuildSystemUtils.getTestTarget())) {
                this.testExecution = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.testExecution) {
            return false;
        }
        if (!roundEnv.processingOver()) {
            roundEnv.getRootElements().stream().map(ElementWrapper::wrap).filter(ElementWrapper::isTypeElement).map(ElementWrapper::toTypeElement).flatMap(this::handle).forEach(this.metadata::add);
            return false;
        }
        if (roundEnv.processingOver()) {
            JsonWriter methodJson = JsonWriter.of(inner -> {
                inner.add("name", MethodMetadata::name);
                inner.add("signature", MethodMetadata::signature);
                inner.add("comment", MethodMetadata::comment).whenNotNull();
            });
            JsonWriter typeJson = JsonWriter.of(members -> {
                members.add("name", TypeMetadata::name);
                members.add("comment", TypeMetadata::comment).whenNotNull();
                members.add("methods", TypeMetadata::methods).whenNotEmpty().as(methods -> methods.stream().map(arg_0 -> ((JsonWriter)methodJson).write(arg_0)).toList());
            });
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Extracting Javadoc into " + this.javadocJson.getAbsolutePath() + ".");
            if (!this.javadocJson.exists()) {
                try {
                    Files.createDirectories(this.javadocJson.toPath().getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            String output = JsonWriter.standard().withNewLineAtEnd().writeToString(this.metadata.stream().sorted(Comparator.comparing(TypeMetadata::name)).map(arg_0 -> ((JsonWriter)typeJson).write(arg_0)).toList());
            try (FileWriter writer = new FileWriter(this.javadocJson);){
                writer.write(output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private Stream<TypeMetadata> handle(TypeElementWrapper type) {
        return SpringModulithProcessor.getTypes(type).flatMap(this::toMetadata);
    }

    private Stream<TypeMetadata> toMetadata(TypeElementWrapper it) {
        List<MethodMetadata> methods = it.getMethods(new Modifier[0]).stream().flatMap(this::toMetadata).toList();
        String comment = this.getComment(it);
        return comment != null || !methods.isEmpty() ? Stream.of(new TypeMetadata(this.getQualifiedName(it), comment, methods)) : Stream.empty();
    }

    private String getQualifiedName(TypeElementWrapper element) {
        Assert.notNull((Object)element, (String)"Element must not be null!");
        if (element.getNestingKind() != NestingKind.MEMBER) {
            return element.getQualifiedName();
        }
        TypeElement enclosing = (TypeElement)ElementUtils.AccessEnclosingElements.getFirstEnclosingElementOfKind(element.unwrap(), new ElementKind[]{ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.RECORD});
        return enclosing != null ? this.getQualifiedName(TypeElementWrapper.wrap(enclosing)) + "$" + element.getSimpleName() : element.getQualifiedName();
    }

    private Stream<MethodMetadata> toMetadata(ExecutableElementWrapper method) {
        String comment = this.getComment(method);
        return comment != null ? Stream.of(new MethodMetadata(method.getSimpleName(), SpringModulithProcessor.getSignature(method), comment)) : Stream.empty();
    }

    @Nullable
    private String getComment(ElementWrapper<?> element) {
        String result = this.elements.getDocComment((Element)element.unwrap());
        if (result == null) {
            return null;
        }
        for (String tag : JAVADOC_TAGS) {
            int index = result.indexOf(tag);
            if (index == -1) continue;
            result = result.substring(0, index);
        }
        return StringUtils.hasText((String)(result = result.trim().replaceAll("\\n *", " "))) ? result : null;
    }

    private static String getSignature(ExecutableElementWrapper wrapper) {
        String parameters = wrapper.getParameters().stream().map(it -> it.asType().getBinaryName()).collect(Collectors.joining(", ", "(", ")"));
        return wrapper.getSimpleName() + parameters;
    }

    private static Stream<TypeElementWrapper> getTypes(TypeElementWrapper type) {
        Stream<TypeElementWrapper> enclosed = type.getEnclosedElements().stream().filter(ElementWrapper::isTypeElement).map(ElementWrapper::toTypeElement);
        return Stream.concat(Stream.of(type), enclosed);
    }

    private static Path getAptOutputFolder(ProcessingEnvironment environment) {
        String boot = environment.getOptions().get("org.springframework.boot.configurationprocessor.additionalMetadataLocations");
        if (boot != null) {
            return Path.of(boot.substring(0, boot.indexOf("/src/main/resources")), new String[0]);
        }
        String kapt = environment.getOptions().get("kapt.kotlin.generated");
        if (kapt != null) {
            return Path.of(kapt.substring(0, kapt.indexOf("/build/generated/source")), new String[0]);
        }
        return Path.of(".", new String[0]);
    }
}

