/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools;

import java.lang.reflect.Array;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.springframework.modulith.aptk.common.ToolingProvider;

public class AnnotationValueUtils {
    private AnnotationValueUtils() {
    }

    public static boolean isInteger(AnnotationValue annotationValue) {
        return AnnotationValueUtils.hasAnnotationValueOneOfPassedTypes(annotationValue, Integer.class);
    }

    public static boolean isLong(AnnotationValue annotationValue) {
        return AnnotationValueUtils.hasAnnotationValueOneOfPassedTypes(annotationValue, Long.class);
    }

    public static boolean isBoolean(AnnotationValue annotationValue) {
        return AnnotationValueUtils.hasAnnotationValueOneOfPassedTypes(annotationValue, Boolean.class);
    }

    public static boolean isFloat(AnnotationValue annotationValue) {
        return AnnotationValueUtils.hasAnnotationValueOneOfPassedTypes(annotationValue, Float.class);
    }

    public static boolean isDouble(AnnotationValue annotationValue) {
        return AnnotationValueUtils.hasAnnotationValueOneOfPassedTypes(annotationValue, Double.class);
    }

    public static boolean isString(AnnotationValue annotationValue) {
        return AnnotationValueUtils.hasAnnotationValueOneOfPassedTypes(annotationValue, String.class);
    }

    public static boolean isChar(AnnotationValue annotationValue) {
        return AnnotationValueUtils.hasAnnotationValueOneOfPassedTypes(annotationValue, Character.class);
    }

    public static boolean isEnum(AnnotationValue annotationValue) {
        return AnnotationValueUtils.hasAnnotationValueOneOfPassedTypes(annotationValue, VariableElement.class);
    }

    public static boolean isClass(AnnotationValue annotationValue) {
        return AnnotationValueUtils.hasAnnotationValueOneOfPassedTypes(annotationValue, TypeMirror.class);
    }

    public static boolean isArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.hasAnnotationValueOneOfPassedTypes(annotationValue, List.class);
    }

    public static boolean isAnnotation(AnnotationValue annotationValue) {
        return AnnotationValueUtils.hasAnnotationValueOneOfPassedTypes(annotationValue, AnnotationMirror.class);
    }

    private static boolean hasAnnotationValueOneOfPassedTypes(AnnotationValue annotationValue, Class<?> ... types) {
        if (annotationValue == null || types == null || types.length == 0) {
            return false;
        }
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(annotationValue.getValue().getClass())) continue;
            return true;
        }
        return false;
    }

    public static Long getLongValue(AnnotationValue annotationValue) {
        return !AnnotationValueUtils.isLong(annotationValue) ? null : (Long)annotationValue.getValue();
    }

    public static Integer getIntegerValue(AnnotationValue annotationValue) {
        return !AnnotationValueUtils.isInteger(annotationValue) ? null : (Integer)annotationValue.getValue();
    }

    public static Boolean getBooleanValue(AnnotationValue annotationValue) {
        return !AnnotationValueUtils.isBoolean(annotationValue) ? null : (Boolean)annotationValue.getValue();
    }

    public static Float getFloatValue(AnnotationValue annotationValue) {
        return !AnnotationValueUtils.isFloat(annotationValue) ? null : (Float)annotationValue.getValue();
    }

    public static Double getDoubleValue(AnnotationValue annotationValue) {
        return !AnnotationValueUtils.isDouble(annotationValue) ? null : (Double)annotationValue.getValue();
    }

    public static String getStringValue(AnnotationValue annotationValue) {
        return !AnnotationValueUtils.isString(annotationValue) ? null : (String)annotationValue.getValue();
    }

    public static Character getCharValue(AnnotationValue annotationValue) {
        return !AnnotationValueUtils.isChar(annotationValue) ? null : (Character)annotationValue.getValue();
    }

    public static Class<?> getClassValue(AnnotationValue annotationValue) {
        TypeMirror typeMirror = AnnotationValueUtils.getTypeMirrorValue(annotationValue);
        if (typeMirror != null) {
            try {
                return Class.forName(typeMirror.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getClassValueAsFQN(AnnotationValue annotationValue) {
        return ((TypeElement)ToolingProvider.getTooling().getTypes().asElement(AnnotationValueUtils.getTypeMirrorValue(annotationValue))).getQualifiedName().toString();
    }

    public static TypeMirror getTypeMirrorValue(AnnotationValue annotationValue) {
        return !AnnotationValueUtils.isClass(annotationValue) ? null : (TypeMirror)annotationValue.getValue();
    }

    public static VariableElement getEnumValue(AnnotationValue annotationValue) {
        return !AnnotationValueUtils.isEnum(annotationValue) ? null : (VariableElement)annotationValue.getValue();
    }

    public static <T extends Enum<T>> T getEnumValue(Class<T> enumType, AnnotationValue annotationValue) {
        VariableElement enumValueElement = AnnotationValueUtils.getEnumValue(annotationValue);
        return enumValueElement != null ? (T)Enum.valueOf(enumType, enumValueElement.getSimpleName().toString()) : null;
    }

    public static AnnotationMirror getAnnotationValue(AnnotationValue annotationValue) {
        return !AnnotationValueUtils.isAnnotation(annotationValue) ? null : (AnnotationMirror)annotationValue.getValue();
    }

    public static List<? extends AnnotationValue> getArrayValue(AnnotationValue annotationValue) {
        return !AnnotationValueUtils.isArray(annotationValue) ? null : (List)annotationValue.getValue();
    }

    public static TypeMirror[] getTypeAttributeValueArray(AnnotationValue annotationValue) {
        List<? extends AnnotationValue> arrayValue = AnnotationValueUtils.getArrayValue(annotationValue);
        return arrayValue != null ? AnnotationValueUtils.getTypeAttributeValueArray(arrayValue) : new TypeMirror[]{};
    }

    public static TypeMirror[] getTypeAttributeValueArray(List<? extends AnnotationValue> annotationValues) {
        TypeMirror[] result = new TypeMirror[annotationValues.size()];
        for (int i = 0; i < annotationValues.size(); ++i) {
            result[i] = (DeclaredType)annotationValues.get(i).getValue();
        }
        return result;
    }

    public static <T> T[] convertAndCastAttributeValueListToArray(List<? extends AnnotationValue> annotatedValues, Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("passed type must not be null!");
        }
        if (annotatedValues == null) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(type, annotatedValues.size());
        for (int i = 0; i < annotatedValues.size(); ++i) {
            result[i] = annotatedValues.get(i).getValue();
        }
        return result;
    }

    public static Long[] getLongValueArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.getLongValueArray(AnnotationValueUtils.getArrayValue(annotationValue));
    }

    public static Long[] getLongValueArray(List<? extends AnnotationValue> annotationValues) {
        if (!AnnotationValueUtils.isAnnotationValueArray(annotationValues, Long.class)) {
            return null;
        }
        return AnnotationValueUtils.convertAndCastAttributeValueListToArray(annotationValues, Long.class);
    }

    public static Integer[] getIntegerValueArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.getIntegerValueArray(AnnotationValueUtils.getArrayValue(annotationValue));
    }

    public static Integer[] getIntegerValueArray(List<? extends AnnotationValue> annotationValues) {
        if (!AnnotationValueUtils.isAnnotationValueArray(annotationValues, Integer.class)) {
            return null;
        }
        return AnnotationValueUtils.convertAndCastAttributeValueListToArray(annotationValues, Integer.class);
    }

    public static Double[] getDoubleValueArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.getDoubleValueArray(AnnotationValueUtils.getArrayValue(annotationValue));
    }

    public static Double[] getDoubleValueArray(List<? extends AnnotationValue> annotationValues) {
        if (!AnnotationValueUtils.isAnnotationValueArray(annotationValues, Double.class)) {
            return null;
        }
        return AnnotationValueUtils.convertAndCastAttributeValueListToArray(annotationValues, Double.class);
    }

    public static Float[] getFloatValueArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.getFloatValueArray(AnnotationValueUtils.getArrayValue(annotationValue));
    }

    public static Float[] getFloatValueArray(List<? extends AnnotationValue> annotationValues) {
        if (!AnnotationValueUtils.isAnnotationValueArray(annotationValues, Float.class)) {
            return null;
        }
        return AnnotationValueUtils.convertAndCastAttributeValueListToArray(annotationValues, Float.class);
    }

    public static Boolean[] getBooleanValueArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.getBooleanValueArray(AnnotationValueUtils.getArrayValue(annotationValue));
    }

    public static Boolean[] getBooleanValueArray(List<? extends AnnotationValue> annotationValues) {
        if (!AnnotationValueUtils.isAnnotationValueArray(annotationValues, Boolean.class)) {
            return null;
        }
        return AnnotationValueUtils.convertAndCastAttributeValueListToArray(annotationValues, Boolean.class);
    }

    public static Character[] getCharValueArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.getCharValueArray(AnnotationValueUtils.getArrayValue(annotationValue));
    }

    public static Character[] getCharValueArray(List<? extends AnnotationValue> annotationValues) {
        if (!AnnotationValueUtils.isAnnotationValueArray(annotationValues, Character.class)) {
            return null;
        }
        return AnnotationValueUtils.convertAndCastAttributeValueListToArray(annotationValues, Character.class);
    }

    public static String[] getStringValueArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.getStringValueArray(AnnotationValueUtils.getArrayValue(annotationValue));
    }

    public static String[] getStringValueArray(List<? extends AnnotationValue> annotationValues) {
        if (!AnnotationValueUtils.isAnnotationValueArray(annotationValues, String.class)) {
            return null;
        }
        return AnnotationValueUtils.convertAndCastAttributeValueListToArray(annotationValues, String.class);
    }

    public static VariableElement[] getEnumValueArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.getEnumValueArray(AnnotationValueUtils.getArrayValue(annotationValue));
    }

    public static VariableElement[] getEnumValueArray(List<? extends AnnotationValue> annotationValues) {
        if (annotationValues == null || !AnnotationValueUtils.isAnnotationValueArray(annotationValues, VariableElement.class)) {
            return null;
        }
        return AnnotationValueUtils.convertAndCastAttributeValueListToArray(annotationValues, VariableElement.class);
    }

    public static AnnotationMirror[] getAnnotationValueArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.getAnnotationValueArray(AnnotationValueUtils.getArrayValue(annotationValue));
    }

    public static AnnotationMirror[] getAnnotationValueArray(List<? extends AnnotationValue> annotationValues) {
        if (!AnnotationValueUtils.isAnnotationValueArray(annotationValues, AnnotationMirror.class)) {
            return null;
        }
        return AnnotationValueUtils.convertAndCastAttributeValueListToArray(annotationValues, AnnotationMirror.class);
    }

    public static boolean isIntegerArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.isAnnotationValueArray(annotationValue, Integer.class);
    }

    public static boolean isLongArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.isAnnotationValueArray(annotationValue, Long.class);
    }

    public static boolean isBooleanArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.isAnnotationValueArray(annotationValue, Boolean.class);
    }

    public static boolean isFloatArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.isAnnotationValueArray(annotationValue, Float.class);
    }

    public static boolean isDoubleArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.isAnnotationValueArray(annotationValue, Double.class);
    }

    public static boolean isStringArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.isAnnotationValueArray(annotationValue, String.class);
    }

    public static boolean isCharArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.isAnnotationValueArray(annotationValue, Character.class);
    }

    public static boolean isEnumArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.isAnnotationValueArray(annotationValue, VariableElement.class);
    }

    public static boolean isClassArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.isAnnotationValueArray(annotationValue, TypeMirror.class);
    }

    public static boolean isArrayArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.isAnnotationValueArray(annotationValue, List.class);
    }

    public static boolean isAnnotationArray(AnnotationValue annotationValue) {
        return AnnotationValueUtils.isAnnotationValueArray(annotationValue, AnnotationMirror.class);
    }

    public static boolean isAnnotationValueArray(AnnotationValue annotationValue, Class<?> type) {
        return annotationValue != null && type != null && annotationValue.getValue() instanceof List && AnnotationValueUtils.isAnnotationValueArray((List)annotationValue.getValue(), type);
    }

    public static boolean isAnnotationValueArray(List<? extends AnnotationValue> annotationValues, Class<?> type) {
        return annotationValues != null && type != null && annotationValues.size() >= 1 && AnnotationValueUtils.hasAnnotationValueOneOfPassedTypes(annotationValues.get(0), type);
    }
}

