/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.fluentvalidator;

import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.springframework.modulith.aptk.tools.command.Command;
import org.springframework.modulith.aptk.tools.command.CommandWithReturnType;
import org.springframework.modulith.aptk.tools.corematcher.ExclusiveCriteriaCoreMatcher;
import org.springframework.modulith.aptk.tools.corematcher.ExclusiveCriteriaElementBasedCoreMatcher;
import org.springframework.modulith.aptk.tools.corematcher.ImplicitCoreMatcher;
import org.springframework.modulith.aptk.tools.corematcher.ImplicitElementBasedCoreMatcher;
import org.springframework.modulith.aptk.tools.corematcher.InclusiveCharacteristicElementBasedCoreMatcher;
import org.springframework.modulith.aptk.tools.corematcher.InclusiveCriteriaCoreMatcher;
import org.springframework.modulith.aptk.tools.corematcher.IsCoreMatcher;
import org.springframework.modulith.aptk.tools.corematcher.IsElementBasedCoreMatcher;
import org.springframework.modulith.aptk.tools.corematcher.PlainValidationMessage;
import org.springframework.modulith.aptk.tools.corematcher.ValidationMessage;
import org.springframework.modulith.aptk.tools.fluentvalidator.impl.FluentValidatorMessage;
import org.springframework.modulith.aptk.tools.fluentvalidator.impl.FluentValidatorState;
import org.springframework.modulith.aptk.tools.matcher.CriteriaMatcher;
import org.springframework.modulith.aptk.tools.matcher.ImplicitMatcher;
import org.springframework.modulith.aptk.tools.validator.ExclusiveCriteriaElementValidator;
import org.springframework.modulith.aptk.tools.validator.ImplicitValidator;
import org.springframework.modulith.aptk.tools.validator.InclusiveCriteriaElementValidator;

public class FluentElementValidator<ELEMENT extends Element> {
    private ELEMENT element;
    private final FluentValidatorState fluentValidatorState;
    private NextValidationContext nextValidationContext = new NextValidationContext();

    private FluentElementValidator(ELEMENT element) {
        this.element = element;
        this.fluentValidatorState = new FluentValidatorState();
    }

    private FluentElementValidator(ELEMENT element, FluentValidatorState fluentValidatorState) {
        this.element = element;
        this.fluentValidatorState = fluentValidatorState;
    }

    public <TARGET_ELEMENT extends Element> FluentElementValidator<TARGET_ELEMENT> is(IsCoreMatcher<ELEMENT, TARGET_ELEMENT> coreMatcher) {
        return new IsFluentValidator(coreMatcher.getValidator(), false).apply();
    }

    public <TARGET_ELEMENT extends Element> FluentElementValidator<ELEMENT> isNot(IsCoreMatcher<ELEMENT, TARGET_ELEMENT> coreMatcher) {
        return new InvertedIsFluentValidator(coreMatcher.getValidator(), true).apply();
    }

    public <TARGET_ELEMENT extends Element> FluentElementValidator<TARGET_ELEMENT> is(IsElementBasedCoreMatcher<TARGET_ELEMENT> coreMatcher) {
        return new IsFluentValidator(coreMatcher.getValidator(), false).apply();
    }

    public <TARGET_ELEMENT extends Element> FluentElementValidator<ELEMENT> isNot(IsElementBasedCoreMatcher<TARGET_ELEMENT> coreMatcher) {
        return new InvertedIsFluentValidator(coreMatcher.getValidator(), true).apply();
    }

    public FluentElementValidator<ELEMENT> applyValidator(ImplicitCoreMatcher<ELEMENT> coreMatcher) {
        return new ImplicitFluentValidator(coreMatcher.getValidator(), false).apply();
    }

    public FluentElementValidator<ELEMENT> applyInvertedValidator(ImplicitCoreMatcher<ELEMENT> coreMatcher) {
        return new ImplicitFluentValidator(coreMatcher.getValidator(), true).apply();
    }

    public FluentElementValidator<ELEMENT> applyValidator(ImplicitElementBasedCoreMatcher coreMatcher) {
        return new ImplicitFluentValidator(coreMatcher.getValidator(), false).apply();
    }

    public FluentElementValidator<ELEMENT> applyInvertedValidator(ImplicitElementBasedCoreMatcher coreMatcher) {
        return new ImplicitFluentValidator(coreMatcher.getValidator(), true).apply();
    }

    public <CRITERIA> InclusiveCharacteristicFluentValidator<ELEMENT, CRITERIA> applyValidator(InclusiveCriteriaCoreMatcher<ELEMENT, CRITERIA> coreMatcher) {
        return new InclusiveCharacteristicFluentValidator(coreMatcher.getValidator(), false);
    }

    public <CRITERIA> InclusiveCharacteristicFluentValidator<ELEMENT, CRITERIA> applyInvertedValidator(InclusiveCriteriaCoreMatcher<ELEMENT, CRITERIA> coreMatcher) {
        return new InclusiveCharacteristicFluentValidator(coreMatcher.getValidator(), true);
    }

    public <CRITERIA> InclusiveCharacteristicFluentValidator<Element, CRITERIA> applyValidator(InclusiveCharacteristicElementBasedCoreMatcher<CRITERIA> coreMatcher) {
        return new InclusiveCharacteristicFluentValidator(coreMatcher.getValidator(), false);
    }

    public <CRITERIA> InclusiveCharacteristicFluentValidator<Element, CRITERIA> applyInvertedValidator(InclusiveCharacteristicElementBasedCoreMatcher<CRITERIA> coreMatcher) {
        return new InclusiveCharacteristicFluentValidator(coreMatcher.getValidator(), true);
    }

    public <CRITERIA> ExclusiveCharacteristicFluentValidator<ELEMENT, CRITERIA> applyValidator(ExclusiveCriteriaCoreMatcher<ELEMENT, CRITERIA> coreMatcher) {
        return new ExclusiveCharacteristicFluentValidator(coreMatcher.getValidator(), false);
    }

    public <CRITERIA> ExclusiveCharacteristicFluentValidator<ELEMENT, CRITERIA> applyInvertedValidator(ExclusiveCriteriaCoreMatcher<ELEMENT, CRITERIA> coreMatcher) {
        return new ExclusiveCharacteristicFluentValidator(coreMatcher.getValidator(), true);
    }

    public <CRITERIA> ExclusiveCharacteristicFluentValidator<Element, CRITERIA> applyValidator(ExclusiveCriteriaElementBasedCoreMatcher<CRITERIA> coreMatcher) {
        return new ExclusiveCharacteristicFluentValidator(coreMatcher.getValidator(), false);
    }

    public <CRITERIA> ExclusiveCharacteristicFluentValidator<Element, CRITERIA> applyInvertedValidator(ExclusiveCriteriaElementBasedCoreMatcher<CRITERIA> coreMatcher) {
        return new ExclusiveCharacteristicFluentValidator(coreMatcher.getValidator(), true);
    }

    public PrepareApplyValidator<ELEMENT> error() {
        this.nextValidationContext.setMessageScope(Diagnostic.Kind.ERROR);
        return new PrepareApplyValidator();
    }

    public PrepareApplyValidator<ELEMENT> warning() {
        this.nextValidationContext.setMessageScope(Diagnostic.Kind.WARNING);
        return new PrepareApplyValidator();
    }

    public PrepareApplyValidator<ELEMENT> note() {
        this.nextValidationContext.setMessageScope(Diagnostic.Kind.NOTE);
        return new PrepareApplyValidator();
    }

    public PrepareApplyValidator<ELEMENT> setCustomMessage(String customMessage) {
        return this.setCustomMessage(PlainValidationMessage.create(customMessage));
    }

    public PrepareApplyValidator<ELEMENT> setCustomMessage(String customMessage, Object ... messageArgs) {
        return this.setCustomMessage(PlainValidationMessage.create(customMessage), messageArgs);
    }

    public PrepareApplyValidator<ELEMENT> setCustomMessage(ValidationMessage customMessage) {
        this.nextValidationContext.setCustomMessage(customMessage, new Object[0]);
        return new PrepareApplyValidator();
    }

    public PrepareApplyValidator<ELEMENT> setCustomMessage(ValidationMessage customMessage, Object ... messageArgs) {
        this.nextValidationContext.setCustomMessage(customMessage, messageArgs);
        return new PrepareApplyValidator();
    }

    public boolean justValidate() {
        return this.fluentValidatorState.getValidationResult();
    }

    public boolean validateAndIssueMessages() {
        this.fluentValidatorState.issueMessages();
        return this.fluentValidatorState.getValidationResult();
    }

    public void executeCommandAndIssueMessages(Command<ELEMENT> command) {
        this.executeCommand(command);
        this.fluentValidatorState.issueMessages();
    }

    public void executeCommand(Command<ELEMENT> command) {
        if (command != null && this.fluentValidatorState.getValidationResult()) {
            command.execute(this.element);
        }
    }

    public <RETURN_TYPE> RETURN_TYPE executeCommandAndIssueMessages(CommandWithReturnType<ELEMENT, RETURN_TYPE> command) {
        RETURN_TYPE result = this.executeCommand(command);
        this.fluentValidatorState.issueMessages();
        return result;
    }

    public <RETURN_TYPE> RETURN_TYPE executeCommand(CommandWithReturnType<ELEMENT, RETURN_TYPE> command) {
        if (command != null && this.fluentValidatorState.getValidationResult()) {
            return command.execute(this.element);
        }
        return null;
    }

    public static <E extends Element> FluentElementValidator<E> createFluentElementValidator(E element) {
        return new FluentElementValidator<E>(element);
    }

    /* synthetic */ FluentElementValidator(Element x0, FluentValidatorState x1, 1 x2) {
        this(x0, x1);
    }

    private class NextValidationContext {
        private ValidationMessage customMessage;
        private Diagnostic.Kind messageScope = Diagnostic.Kind.ERROR;
        private Object[] messageArgs;

        private NextValidationContext() {
        }

        private void reset() {
            this.customMessage = null;
            this.messageScope = Diagnostic.Kind.ERROR;
        }

        public ValidationMessage getCustomMessage() {
            return this.customMessage;
        }

        public void setCustomMessage(final String customMessage) {
            this.customMessage = new ValidationMessage(){

                @Override
                public String getCode() {
                    return null;
                }

                @Override
                public String getMessage() {
                    return customMessage;
                }
            };
        }

        public final void setCustomMessage(ValidationMessage customMessage, Object ... messageArgs) {
            this.customMessage = customMessage;
            this.messageArgs = messageArgs;
        }

        public Object[] getMessageArgs() {
            return this.messageArgs;
        }

        public Diagnostic.Kind getMessageScope() {
            return this.messageScope;
        }

        public void setMessageScope(Diagnostic.Kind messageScope) {
            this.messageScope = messageScope;
        }
    }

    public class IsFluentValidator<VALIDATOR_ELEMENT extends Element, TARGET_ELEMENT extends Element>
    extends AbstractFluentValidatorBase<VALIDATOR_ELEMENT, IsFluentValidator<VALIDATOR_ELEMENT, TARGET_ELEMENT>> {
        private final ImplicitValidator<VALIDATOR_ELEMENT, ImplicitMatcher<VALIDATOR_ELEMENT>> validator;

        private IsFluentValidator(ImplicitValidator<VALIDATOR_ELEMENT, ImplicitMatcher<VALIDATOR_ELEMENT>> validator, boolean inverted) {
            super(inverted);
            this.validator = validator;
        }

        public FluentElementValidator<TARGET_ELEMENT> apply() {
            boolean validationResult = false;
            if (FluentElementValidator.this.element != null) {
                validationResult = this.validator.validate(FluentElementValidator.this.element);
                this.setValidationResult(validationResult, this.validator.getDefaultMessage(), "");
            }
            return new FluentElementValidator(validationResult ? FluentElementValidator.this.element : null, FluentElementValidator.this.fluentValidatorState, null);
        }
    }

    public class InvertedIsFluentValidator<VALIDATOR_ELEMENT extends Element, TARGET_ELEMENT extends Element>
    extends AbstractFluentValidatorBase<VALIDATOR_ELEMENT, InvertedIsFluentValidator<VALIDATOR_ELEMENT, TARGET_ELEMENT>> {
        private final ImplicitValidator<VALIDATOR_ELEMENT, ImplicitMatcher<VALIDATOR_ELEMENT>> validator;

        private InvertedIsFluentValidator(ImplicitValidator<VALIDATOR_ELEMENT, ImplicitMatcher<VALIDATOR_ELEMENT>> validator, boolean inverted) {
            super(inverted);
            this.validator = validator;
        }

        public FluentElementValidator<ELEMENT> apply() {
            if (FluentElementValidator.this.element != null) {
                boolean validationResult = this.validator.validate(FluentElementValidator.this.element);
                this.setValidationResult(validationResult, this.validator.getDefaultMessage(), "not");
            }
            return FluentElementValidator.this;
        }
    }

    public class ImplicitFluentValidator<VALIDATOR_ELEMENT extends Element>
    extends AbstractFluentValidatorBase<VALIDATOR_ELEMENT, ImplicitFluentValidator<VALIDATOR_ELEMENT>> {
        private final ImplicitValidator<VALIDATOR_ELEMENT, ImplicitMatcher<VALIDATOR_ELEMENT>> validator;

        private ImplicitFluentValidator(ImplicitValidator<VALIDATOR_ELEMENT, ImplicitMatcher<VALIDATOR_ELEMENT>> validator, boolean inverted) {
            super(inverted);
            this.validator = validator;
        }

        public FluentElementValidator<ELEMENT> apply() {
            if (FluentElementValidator.this.element != null) {
                this.setValidationResult(this.validator.validate(FluentElementValidator.this.element), this.validator.getDefaultMessage(), this.isInverted() ? "not" : "");
            }
            return FluentElementValidator.this;
        }
    }

    public class InclusiveCharacteristicFluentValidator<VALIDATOR_ELEMENT extends Element, CHARACTERISTIC>
    extends AbstractFluentValidatorBase<VALIDATOR_ELEMENT, InclusiveCharacteristicFluentValidator<VALIDATOR_ELEMENT, CHARACTERISTIC>> {
        private final InclusiveCriteriaElementValidator<VALIDATOR_ELEMENT, CHARACTERISTIC, CriteriaMatcher<VALIDATOR_ELEMENT, CHARACTERISTIC>> validator;

        private InclusiveCharacteristicFluentValidator(InclusiveCriteriaElementValidator<VALIDATOR_ELEMENT, CHARACTERISTIC, CriteriaMatcher<VALIDATOR_ELEMENT, CHARACTERISTIC>> validator, boolean inverted) {
            super(inverted);
            this.validator = validator;
        }

        @SafeVarargs
        public final FluentElementValidator<ELEMENT> hasOneOf(CHARACTERISTIC ... params) {
            if (FluentElementValidator.this.element != null) {
                this.setValidationResult(this.validator.hasOneOf(FluentElementValidator.this.element, params), this.validator.getDefaultMessage(), this.isInverted() ? "not" : "", "one", params);
            }
            return FluentElementValidator.this;
        }

        @SafeVarargs
        public final FluentElementValidator<ELEMENT> hasNoneOf(CHARACTERISTIC ... params) {
            if (FluentElementValidator.this.element != null) {
                this.setValidationResult(this.validator.hasNoneOf(FluentElementValidator.this.element, params), this.validator.getDefaultMessage(), this.isInverted() ? "not" : "", "none", params);
            }
            return FluentElementValidator.this;
        }

        @SafeVarargs
        public final FluentElementValidator<ELEMENT> hasAtLeastOneOf(CHARACTERISTIC ... params) {
            if (FluentElementValidator.this.element != null) {
                this.setValidationResult(this.validator.hasAtLeastOneOf(FluentElementValidator.this.element, params), this.validator.getDefaultMessage(), this.isInverted() ? "not" : "", "at least one", params);
            }
            return FluentElementValidator.this;
        }

        @SafeVarargs
        public final FluentElementValidator<ELEMENT> hasAllOf(CHARACTERISTIC ... params) {
            if (FluentElementValidator.this.element != null) {
                this.setValidationResult(this.validator.hasAllOf(FluentElementValidator.this.element, params), this.validator.getDefaultMessage(), this.isInverted() ? "not" : "", "all", params);
            }
            return FluentElementValidator.this;
        }
    }

    public class ExclusiveCharacteristicFluentValidator<VALIDATOR_ELEMENT extends Element, CHARACTERISTIC>
    extends AbstractFluentValidatorBase<VALIDATOR_ELEMENT, ExclusiveCharacteristicFluentValidator<VALIDATOR_ELEMENT, CHARACTERISTIC>> {
        private final ExclusiveCriteriaElementValidator<VALIDATOR_ELEMENT, CHARACTERISTIC, CriteriaMatcher<VALIDATOR_ELEMENT, CHARACTERISTIC>> validator;

        private ExclusiveCharacteristicFluentValidator(ExclusiveCriteriaElementValidator<VALIDATOR_ELEMENT, CHARACTERISTIC, CriteriaMatcher<VALIDATOR_ELEMENT, CHARACTERISTIC>> validator, boolean inverted) {
            super(inverted);
            this.validator = validator;
        }

        @SafeVarargs
        public final FluentElementValidator<ELEMENT> hasOneOf(CHARACTERISTIC ... params) {
            if (FluentElementValidator.this.element != null) {
                this.setValidationResult(this.validator.hasOneOf(FluentElementValidator.this.element, params), this.validator.getDefaultMessage(), this.isInverted() ? "not" : "", "one", params);
            }
            return FluentElementValidator.this;
        }

        @SafeVarargs
        public final FluentElementValidator<ELEMENT> hasNoneOf(CHARACTERISTIC ... params) {
            if (FluentElementValidator.this.element != null) {
                this.setValidationResult(this.validator.hasNoneOf(FluentElementValidator.this.element, params), this.validator.getDefaultMessage(), this.isInverted() ? "not" : "", "none", params);
            }
            return FluentElementValidator.this;
        }
    }

    public class PrepareApplyValidator<PREPARE_VALIDATOR_ELEMENT extends Element> {
        public PrepareApplyValidator<PREPARE_VALIDATOR_ELEMENT> error() {
            return FluentElementValidator.this.error();
        }

        public PrepareApplyValidator<PREPARE_VALIDATOR_ELEMENT> warning() {
            return FluentElementValidator.this.warning();
        }

        public PrepareApplyValidator<PREPARE_VALIDATOR_ELEMENT> note() {
            return FluentElementValidator.this.note();
        }

        public PrepareApplyValidator<PREPARE_VALIDATOR_ELEMENT> setCustomMessage(String customMessage) {
            return this.setCustomMessage(PlainValidationMessage.create(customMessage));
        }

        public final PrepareApplyValidator<PREPARE_VALIDATOR_ELEMENT> setCustomMessage(String customMessage, Object ... messagArgs) {
            return this.setCustomMessage(PlainValidationMessage.create(customMessage), messagArgs);
        }

        public PrepareApplyValidator<PREPARE_VALIDATOR_ELEMENT> setCustomMessage(ValidationMessage customMessage) {
            return FluentElementValidator.this.setCustomMessage(customMessage);
        }

        public final PrepareApplyValidator<PREPARE_VALIDATOR_ELEMENT> setCustomMessage(ValidationMessage customMessage, Object ... messagArgs) {
            return FluentElementValidator.this.setCustomMessage(customMessage, messagArgs);
        }

        public <TARGET_ELEMENT extends Element> FluentElementValidator<TARGET_ELEMENT> is(IsCoreMatcher<ELEMENT, TARGET_ELEMENT> coreMatcher) {
            return FluentElementValidator.this.is(coreMatcher);
        }

        public <TARGET_ELEMENT extends Element> FluentElementValidator<ELEMENT> isNot(IsCoreMatcher<ELEMENT, TARGET_ELEMENT> coreMatcher) {
            return FluentElementValidator.this.isNot(coreMatcher);
        }

        public <TARGET_ELEMENT extends Element> FluentElementValidator<TARGET_ELEMENT> is(IsElementBasedCoreMatcher<TARGET_ELEMENT> coreMatcher) {
            return FluentElementValidator.this.is(coreMatcher);
        }

        public <TARGET_ELEMENT extends Element> FluentElementValidator<ELEMENT> isNot(IsElementBasedCoreMatcher<TARGET_ELEMENT> coreMatcher) {
            return FluentElementValidator.this.isNot(coreMatcher);
        }

        public FluentElementValidator<ELEMENT> applyValidator(ImplicitCoreMatcher<ELEMENT> coreMatcher) {
            return FluentElementValidator.this.applyValidator(coreMatcher);
        }

        public FluentElementValidator<ELEMENT> applyInvertedValidator(ImplicitCoreMatcher<ELEMENT> coreMatcher) {
            return FluentElementValidator.this.applyInvertedValidator(coreMatcher);
        }

        public FluentElementValidator<ELEMENT> applyValidator(ImplicitElementBasedCoreMatcher coreMatcher) {
            return FluentElementValidator.this.applyValidator(coreMatcher);
        }

        public FluentElementValidator<ELEMENT> applyInvertedValidator(ImplicitElementBasedCoreMatcher coreMatcher) {
            return FluentElementValidator.this.applyInvertedValidator(coreMatcher);
        }

        public <CRITERIA> InclusiveCharacteristicFluentValidator<ELEMENT, CRITERIA> applyValidator(InclusiveCriteriaCoreMatcher<ELEMENT, CRITERIA> coreMatcher) {
            return FluentElementValidator.this.applyValidator(coreMatcher);
        }

        public <CRITERIA> InclusiveCharacteristicFluentValidator<ELEMENT, CRITERIA> applyInvertedValidator(InclusiveCriteriaCoreMatcher<ELEMENT, CRITERIA> coreMatcher) {
            return FluentElementValidator.this.applyInvertedValidator(coreMatcher);
        }

        public <CRITERIA> InclusiveCharacteristicFluentValidator<Element, CRITERIA> applyValidator(InclusiveCharacteristicElementBasedCoreMatcher<CRITERIA> coreMatcher) {
            return FluentElementValidator.this.applyValidator(coreMatcher);
        }

        public <CRITERIA> InclusiveCharacteristicFluentValidator<Element, CRITERIA> applyInvertedValidator(InclusiveCharacteristicElementBasedCoreMatcher<CRITERIA> coreMatcher) {
            return FluentElementValidator.this.applyInvertedValidator(coreMatcher);
        }

        public <CRITERIA> ExclusiveCharacteristicFluentValidator<ELEMENT, CRITERIA> applyValidator(ExclusiveCriteriaCoreMatcher<ELEMENT, CRITERIA> coreMatcher) {
            return FluentElementValidator.this.applyValidator(coreMatcher);
        }

        public <CRITERIA> ExclusiveCharacteristicFluentValidator<ELEMENT, CRITERIA> applyInvertedValidator(ExclusiveCriteriaCoreMatcher<ELEMENT, CRITERIA> coreMatcher) {
            return FluentElementValidator.this.applyInvertedValidator(coreMatcher);
        }

        public <CRITERIA> ExclusiveCharacteristicFluentValidator<Element, CRITERIA> applyValidator(ExclusiveCriteriaElementBasedCoreMatcher<CRITERIA> coreMatcher) {
            return FluentElementValidator.this.applyValidator(coreMatcher);
        }

        public <CRITERIA> ExclusiveCharacteristicFluentValidator<Element, CRITERIA> applyInvertedValidator(ExclusiveCriteriaElementBasedCoreMatcher<CRITERIA> coreMatcher) {
            return FluentElementValidator.this.applyInvertedValidator(coreMatcher);
        }
    }

    public abstract class AbstractFluentValidatorBase<VALIDATOR_ELEMENT extends Element, VALIDATOR extends AbstractFluentValidatorBase<VALIDATOR_ELEMENT, VALIDATOR>> {
        private boolean inverted;

        public AbstractFluentValidatorBase(boolean inverted) {
            this.inverted = inverted;
        }

        protected boolean isInverted() {
            return this.inverted;
        }

        protected final void setValidationResult(boolean validationResult, ValidationMessage defaultMessage, Object ... messsageParameter) {
            if (!validationResult && !this.inverted || validationResult && this.inverted) {
                ValidationMessage forgedValidationMessage;
                boolean hasCustomMessage;
                FluentElementValidator.this.fluentValidatorState.setAsFailedValidation();
                boolean bl = hasCustomMessage = FluentElementValidator.this.nextValidationContext.getCustomMessage() != null;
                ValidationMessage validationMessage = !hasCustomMessage ? defaultMessage : (forgedValidationMessage = PlainValidationMessage.create(FluentElementValidator.this.nextValidationContext.getCustomMessage().getCode() != null ? FluentElementValidator.this.nextValidationContext.getCustomMessage().getCode() : defaultMessage.getCode(), FluentElementValidator.this.nextValidationContext.getCustomMessage().getMessage()));
                Object[] messageArgs = !hasCustomMessage ? messsageParameter : (FluentElementValidator.this.nextValidationContext.getMessageArgs() != null ? FluentElementValidator.this.nextValidationContext.getMessageArgs() : new Object[]{});
                FluentElementValidator.this.fluentValidatorState.addMessage(new FluentValidatorMessage(FluentElementValidator.this.element, FluentElementValidator.this.nextValidationContext.getMessageScope(), forgedValidationMessage, messageArgs));
                FluentElementValidator.this.nextValidationContext.reset();
            }
        }
    }
}

