/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.wrapper;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.modulith.aptk.tools.ElementUtils;
import org.springframework.modulith.aptk.tools.TypeMirrorWrapper;
import org.springframework.modulith.aptk.tools.corematcher.AptkCoreMatchers;
import org.springframework.modulith.aptk.tools.fluentfilter.FluentElementFilter;
import org.springframework.modulith.aptk.tools.wrapper.ElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.ExecutableElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.RecordComponentElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.TypeParameterElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.VariableElementWrapper;

public class TypeElementWrapper
extends ElementWrapper<TypeElement> {
    private static final String TYPE_ELEMENT_CLASS_NAME = "javax.lang.model.element.TypeElement";
    private static ElementKind[] TYPE_ELEMENT_KINDS;

    private TypeElementWrapper(TypeElement typeElement) {
        super(typeElement);
    }

    public NestingKind getNestingKind() {
        return ((TypeElement)this.element).getNestingKind();
    }

    public boolean hasNestingKind(NestingKind nestingKind) {
        return nestingKind != null && this.getNestingKind().equals((Object)nestingKind);
    }

    public boolean isNested() {
        return this.getNestingKind().isNested();
    }

    public String getNestedName() {
        String name = this.getSimpleName();
        TypeElementWrapper current = this;
        while (current.isNested()) {
            current = current.getOuterType().get();
            name = current.getSimpleName() + "." + name;
        }
        return name;
    }

    public String getQualifiedName() {
        return ((TypeElement)this.element).getQualifiedName().toString();
    }

    public boolean hasQualifiedName(String name) {
        return name != null && this.getQualifiedName().equals(name);
    }

    public String getBinaryName() {
        if (this.isNested()) {
            TypeElementWrapper enclosingTypeElement = this.getOuterType().get();
            return enclosingTypeElement.getBinaryName() + "$" + this.getSimpleName();
        }
        return this.getQualifiedName();
    }

    public TypeMirrorWrapper getSuperclass() {
        return TypeMirrorWrapper.wrap(((TypeElement)this.element).getSuperclass());
    }

    public List<TypeMirrorWrapper> getInterfaces() {
        return ((TypeElement)this.element).getInterfaces().stream().map(TypeMirrorWrapper::wrap).collect(Collectors.toList());
    }

    public Set<TypeMirrorWrapper> getAllInterfaces() {
        HashSet<TypeMirrorWrapper> result = new HashSet<TypeMirrorWrapper>(this.getInterfaces());
        Optional<TypeElementWrapper> superClass = this.getSuperclass().getTypeElement();
        superClass.ifPresent(typeElementWrapper -> result.addAll(typeElementWrapper.getAllInterfaces()));
        return result;
    }

    public List<TypeParameterElementWrapper> getTypeParameters() {
        return ((TypeElement)this.element).getTypeParameters().stream().map(TypeParameterElementWrapper::wrap).collect(Collectors.toList());
    }

    public boolean hasTypeParameters() {
        return this.getTypeParameters().size() > 0;
    }

    public Optional<ExecutableElementWrapper> getMethod(String name, Class<?> ... parameterTypes) {
        List filterResult = FluentElementFilter.createFluentElementFilter(((TypeElement)this.element).getEnclosedElements()).applyFilter(AptkCoreMatchers.IS_METHOD).applyFilter(AptkCoreMatchers.BY_NAME).filterByOneOf((String[])new String[]{name}).applyFilter(AptkCoreMatchers.BY_PARAMETER_TYPE).filterByOneOf((CRITERIA[])new Class[][]{parameterTypes}).getResult();
        return Optional.ofNullable(filterResult.size() > 0 ? ExecutableElementWrapper.wrap((ExecutableElement)filterResult.get(0)) : null);
    }

    public List<ExecutableElementWrapper> getMethods(Modifier ... modifier) {
        return FluentElementFilter.createFluentElementFilter(((TypeElement)this.element).getEnclosedElements()).applyFilter(AptkCoreMatchers.IS_METHOD).applyFilter(AptkCoreMatchers.BY_MODIFIER).filterByAllOf((Modifier[])modifier).getResult().stream().map(ExecutableElementWrapper::wrap).collect(Collectors.toList());
    }

    public List<VariableElementWrapper> getFields(Modifier ... modifier) {
        return FluentElementFilter.createFluentElementFilter(((TypeElement)this.element).getEnclosedElements()).applyFilter(AptkCoreMatchers.IS_FIELD).applyFilter(AptkCoreMatchers.BY_MODIFIER).filterByAllOf((Modifier[])modifier).getResult().stream().map(VariableElementWrapper::wrap).collect(Collectors.toList());
    }

    public Optional<VariableElementWrapper> getFieldByName(String name) {
        List fields = FluentElementFilter.createFluentElementFilter(((TypeElement)this.element).getEnclosedElements()).applyFilter(AptkCoreMatchers.IS_FIELD).applyFilter(AptkCoreMatchers.BY_NAME).filterByOneOf((String[])new String[]{name}).getResult().stream().map(VariableElementWrapper::wrap).collect(Collectors.toList());
        return Optional.ofNullable(fields.size() > 0 ? (VariableElementWrapper)fields.get(0) : null);
    }

    public List<ExecutableElementWrapper> getConstructors(Modifier ... modifier) {
        return FluentElementFilter.createFluentElementFilter(((TypeElement)this.element).getEnclosedElements()).applyFilter(AptkCoreMatchers.IS_CONSTRUCTOR).applyFilter(AptkCoreMatchers.BY_MODIFIER).filterByAllOf((Modifier[])modifier).getResult().stream().map(ExecutableElementWrapper::wrap).collect(Collectors.toList());
    }

    public List<TypeElementWrapper> getInnerTypes(Modifier ... modifier) {
        return FluentElementFilter.createFluentElementFilter(((TypeElement)this.element).getEnclosedElements()).applyFilter(AptkCoreMatchers.IS_TYPE).applyFilter(AptkCoreMatchers.BY_MODIFIER).filterByAllOf((Modifier[])modifier).getResult().stream().map(TypeElementWrapper::wrap).collect(Collectors.toList());
    }

    public Optional<TypeElementWrapper> getOuterType() {
        if (((TypeElement)this.element).getNestingKind() != NestingKind.MEMBER) {
            return Optional.empty();
        }
        return Optional.of(TypeElementWrapper.wrap((TypeElement)ElementUtils.AccessEnclosingElements.getFirstEnclosingElementOfKind(this.element, TYPE_ELEMENT_KINDS)));
    }

    public Optional<TypeElementWrapper> getOuterTopLevelType() {
        if (((TypeElement)this.element).getNestingKind() != NestingKind.MEMBER) {
            return Optional.empty();
        }
        return Optional.of((TypeElementWrapper)this.getAllEnclosingElements().stream().filter(ElementWrapper::isTypeElement).map(ElementWrapper::toTypeElement).filter(e -> e.hasNestingKind(NestingKind.TOP_LEVEL)).collect(Collectors.toList()).get(0));
    }

    public List<VariableElementWrapper> getEnumValues() {
        return this.isEnum() ? this.filterEnclosedElements().applyFilter(AptkCoreMatchers.BY_ELEMENT_KIND).filterByOneOf((ElementKind[])new ElementKind[]{ElementKind.ENUM_CONSTANT}).getResult().stream().map(e -> VariableElementWrapper.wrap((VariableElement)e)).collect(Collectors.toList()) : null;
    }

    public List<RecordComponentElementWrapper> getRecordComponents() {
        if (!this.isRecord()) {
            return Collections.emptyList();
        }
        List recordComponentElements = (List)this.invokeParameterlessMethodOfElement(TYPE_ELEMENT_CLASS_NAME, "getRecordComponents");
        return recordComponentElements.stream().map(RecordComponentElementWrapper::wrap).collect(Collectors.toList());
    }

    public List<TypeMirrorWrapper> getPermittedSubclasses() {
        if (!this.hasMethod(TYPE_ELEMENT_CLASS_NAME, "getPermittedSubclasses")) {
            return Collections.emptyList();
        }
        List typeMirrors = (List)this.invokeParameterlessMethodOfElement(TYPE_ELEMENT_CLASS_NAME, "getPermittedSubclasses");
        return typeMirrors.stream().map(TypeMirrorWrapper::wrap).collect(Collectors.toList());
    }

    public static TypeElementWrapper wrap(TypeElement element) {
        return new TypeElementWrapper(element);
    }

    public static Optional<TypeElementWrapper> getByFqn(String fqn) {
        return TypeElementWrapper.getByTypeMirror(TypeMirrorWrapper.wrap(fqn));
    }

    public static Optional<TypeElementWrapper> getByClass(Class<?> clazz) {
        return TypeElementWrapper.getByTypeMirror(TypeMirrorWrapper.wrap(clazz));
    }

    public static Optional<TypeElementWrapper> getByTypeMirror(TypeMirror typeMirror) {
        return TypeElementWrapper.getByTypeMirror(TypeMirrorWrapper.wrap(typeMirror));
    }

    public static Optional<TypeElementWrapper> getByTypeMirror(TypeMirrorWrapper typeMirror) {
        return typeMirror.getTypeElement();
    }

    static {
        try {
            ElementKind[] typeKinds = new ElementKind[]{ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.valueOf("RECORD")};
            TYPE_ELEMENT_KINDS = typeKinds;
        }
        catch (IllegalArgumentException e) {
            ElementKind[] typeKinds = new ElementKind[]{ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE};
            TYPE_ELEMENT_KINDS = typeKinds;
        }
    }
}

