/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.matcher.impl;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.springframework.modulith.aptk.tools.TypeUtils;
import org.springframework.modulith.aptk.tools.matcher.CriteriaMatcher;

public class ByParameterTypeMatcher
implements CriteriaMatcher<ExecutableElement, Class[]> {
    @Override
    public boolean checkForMatchingCharacteristic(ExecutableElement element, Class[] toCheckFor) {
        if (element == null || toCheckFor == null) {
            return false;
        }
        if (element.getParameters().size() != toCheckFor.length) {
            return false;
        }
        for (int i = 0; i < element.getParameters().size(); ++i) {
            VariableElement parameterElement = element.getParameters().get(i);
            if (TypeUtils.TypeComparison.isErasedTypeEqual(parameterElement.asType(), TypeUtils.TypeRetrieval.getTypeMirror(toCheckFor[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getStringRepresentationOfPassedCharacteristic(Class[] toGetStringRepresentationFor) {
        if (toGetStringRepresentationFor != null) {
            StringBuilder stringBuilder = new StringBuilder("[");
            boolean isFirst = true;
            for (Class element : toGetStringRepresentationFor) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(element.getCanonicalName());
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        return null;
    }
}

