/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.docs;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModuleDependency;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.ArchitecturallyEvidentType;
import org.springframework.modulith.core.DependencyType;
import org.springframework.modulith.core.EventType;
import org.springframework.modulith.core.FormatableType;
import org.springframework.modulith.core.Source;
import org.springframework.modulith.core.SpringBean;
import org.springframework.modulith.docs.CodeReplacingDocumentationSource;
import org.springframework.modulith.docs.ConfigurationProperties;
import org.springframework.modulith.docs.DocumentationSource;
import org.springframework.modulith.docs.Documenter;
import org.springframework.modulith.docs.SpringAutoRestDocsDocumentationSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class Asciidoctor {
    private static String PLACEHOLDER = "\u00af\\_(\u30c4)_/\u00af";
    private static final Pattern JAVADOC_CODE = Pattern.compile("\\{\\@(?>link|code|literal)\\s(.*)\\}");
    private final ApplicationModules modules;
    private final String javaDocBase;
    private final Optional<DocumentationSource> docSource;

    private Asciidoctor(ApplicationModules modules, String javaDocBase) {
        Assert.notNull((Object)modules, (String)"Modules must not be null!");
        Assert.hasText((String)javaDocBase, (String)"Javadoc base must not be null or empty!");
        this.javaDocBase = javaDocBase;
        this.modules = modules;
        this.docSource = Optional.of("capital.scalable.restdocs.javadoc.JavadocReaderImpl").filter(it -> ClassUtils.isPresent((String)it, (ClassLoader)Asciidoctor.class.getClassLoader())).map(__ -> new SpringAutoRestDocsDocumentationSource()).map(it -> new CodeReplacingDocumentationSource((DocumentationSource)it, this));
    }

    public static Asciidoctor withJavadocBase(ApplicationModules modules, @Nullable String javadocBase) {
        return new Asciidoctor(modules, javadocBase == null ? PLACEHOLDER : javadocBase);
    }

    public static Asciidoctor withoutJavadocBase(ApplicationModules modules) {
        return new Asciidoctor(modules, PLACEHOLDER);
    }

    public String toInlineCode(String source) {
        String[] parts = source.split("#");
        String type = parts[0];
        Optional methodSignature = parts.length == 2 ? Optional.of(parts[1]) : Optional.empty();
        return this.modules.getModuleByType(type).flatMap(it -> it.getType(type)).map(it -> this.toOptionalLink((JavaClass)it, methodSignature)).orElseGet(() -> String.format("`%s`", type));
    }

    public String toInlineCode(JavaClass type) {
        return this.toOptionalLink(type);
    }

    public String toInlineCode(SpringBean bean) {
        String base = this.toInlineCode(bean.toArchitecturallyEvidentType());
        List interfaces = bean.getInterfacesWithinModule();
        if (interfaces.isEmpty()) {
            return base;
        }
        String interfacesAsString = interfaces.stream().map(this::toInlineCode).collect(Collectors.joining(", "));
        return String.format("%s (via %s)", interfacesAsString, base);
    }

    public String renderSpringBeans(ApplicationModule module, Documenter.CanvasOptions options) {
        StringBuilder builder = new StringBuilder();
        Documenter.CanvasOptions.Groupings groupings = options.groupBeans(module);
        if (groupings.hasOnlyFallbackGroup()) {
            return this.toBulletPoints(groupings.byGrouping(Documenter.CanvasOptions.FALLBACK_GROUP));
        }
        groupings.forEach((grouping, beans) -> {
            if (beans.isEmpty()) {
                return;
            }
            if (builder.length() != 0) {
                builder.append("\n\n");
            }
            builder.append("_").append(grouping.getName()).append("_");
            if (grouping.getDescription() != null) {
                builder.append(" -- ").append(grouping.getDescription());
            }
            builder.append("\n\n");
            builder.append(this.toBulletPoints((List<SpringBean>)beans));
        });
        return builder.length() == 0 ? "None" : builder.toString();
    }

    public String renderEvents(ApplicationModule module) {
        List events = module.getPublishedEvents();
        if (events.isEmpty()) {
            return "none";
        }
        StringBuilder builder = new StringBuilder();
        for (EventType eventType : events) {
            builder.append("* ").append(this.toInlineCode(eventType.getType()));
            if (!eventType.hasSources()) {
                builder.append("\n");
            } else {
                builder.append(" created by:\n");
            }
            for (Source source : eventType.getSources()) {
                builder.append("** ").append(this.toInlineCode(source.toString(module))).append("\n");
            }
        }
        return builder.toString();
    }

    public String renderConfigurationProperties(List<ConfigurationProperties.ModuleProperty> properties) {
        if (properties.isEmpty()) {
            return "none";
        }
        Stream<String> stream = properties.stream().map(it -> {
            String description;
            StringBuilder builder = new StringBuilder().append(Asciidoctor.toCode(it.name())).append(" -- ").append(this.toInlineCode(it.type()));
            String defaultValue = it.defaultValue();
            if (defaultValue != null && StringUtils.hasText((String)defaultValue)) {
                builder = builder.append(", default ").append(this.toInlineCode(defaultValue));
            }
            if ((description = it.description()) != null && StringUtils.hasText((String)description)) {
                builder = builder.append(". ").append(this.toAsciidoctor(description));
            }
            return builder.toString();
        });
        return this.toBulletPoints(stream);
    }

    private String toBulletPoints(List<SpringBean> beans) {
        return this.toBulletPoints(beans.stream().map(this::toInlineCode));
    }

    public String typesToBulletPoints(List<JavaClass> types) {
        return this.toBulletPoints(types.stream().map(this::toOptionalLink));
    }

    private String toBulletPoints(Stream<String> types) {
        return types.collect(Collectors.joining("\n* ", "* ", ""));
    }

    public String toBulletPoint(String source) {
        return String.format("* %s", source);
    }

    private String toOptionalLink(JavaClass source) {
        return this.toOptionalLink(source, Optional.empty());
    }

    private String toOptionalLink(JavaClass source, Optional<String> methodSignature) {
        ApplicationModule module = this.modules.getModuleByType(source).orElse(null);
        String typeAndMethod = Asciidoctor.toCode(Asciidoctor.toTypeAndMethod(FormatableType.of((JavaClass)source).getAbbreviatedFullName(module), methodSignature));
        if (module == null || !source.getModifiers().contains(JavaModifier.PUBLIC) || !module.contains(source)) {
            return typeAndMethod;
        }
        String classPath = ClassUtils.convertClassNameToResourcePath((String)source.getFullName()).replace('$', '.');
        return Optional.ofNullable(this.javaDocBase == PLACEHOLDER ? null : this.javaDocBase).map(it -> it.concat("/").concat(classPath).concat(".html")).map(it -> Asciidoctor.toLink(typeAndMethod, it)).orElseGet(() -> typeAndMethod);
    }

    private static String toTypeAndMethod(String type, Optional<String> methodSignature) {
        return methodSignature.map(it -> type.concat("#").concat((String)it)).orElse(type);
    }

    private String toInlineCode(ArchitecturallyEvidentType type) {
        if (type.isEventListener()) {
            if (!this.docSource.isPresent()) {
                Stream referenceTypes = type.getReferenceTypes();
                return String.format("%s listening to %s", this.toInlineCode(type.getType()), this.toInlineCode(referenceTypes));
            }
            String header = String.format("%s listening to:\n", this.toInlineCode(type.getType()));
            return header + type.getReferenceMethods().map(it -> {
                JavaMethod method = it.getMethod();
                List<Class> exposedReferenceTypes = it.getReferenceTypes().stream().filter(refType -> this.modules.getModuleByType(refType).map(module -> module.isExposed(refType)).orElse(true)).toList();
                String isAsync = it.isAsync() ? "(async) " : "";
                return this.docSource.flatMap(source -> source.getDocumentation(method)).map(doc -> String.format("** %s %s-- %s", this.toInlineCode(exposedReferenceTypes), isAsync, doc)).orElseGet(() -> String.format("** %s %s", this.toInlineCode(exposedReferenceTypes), isAsync));
            }).collect(Collectors.joining("\n"));
        }
        return this.toInlineCode(type.getType());
    }

    private String toInlineCode(Stream<JavaClass> types) {
        return types.map(this::toInlineCode).collect(Collectors.joining(", "));
    }

    private String toInlineCode(Collection<Class<?>> types) {
        return types.stream().map(Class::getName).map(this::toInlineCode).collect(Collectors.joining(", "));
    }

    private static String toLink(String source, String href) {
        return String.format("link:%s[%s]", href, source);
    }

    private static String toCode(String source) {
        return String.format("`%s`", source);
    }

    public static String startTable(String tableSpec) {
        return String.format("[%s]\n|===\n", tableSpec);
    }

    public static String startOrEndTable() {
        return "|===\n";
    }

    public static String writeTableRow(String ... columns) {
        return Stream.of(columns).collect(Collectors.joining("\n|", "|", "\n"));
    }

    public String toAsciidoctor(String source) {
        Matcher matcher = JAVADOC_CODE.matcher(source);
        while (matcher.find()) {
            String type = matcher.group(1);
            source = source.replace(matcher.group(), this.toInlineCode(type));
        }
        return source;
    }

    public String renderBeanReferences(ApplicationModule module) {
        String bullets = module.getDependencies(this.modules, new DependencyType[]{DependencyType.USES_COMPONENT}).uniqueStream(ApplicationModuleDependency::getTargetType).map(it -> "%s (in %s)".formatted(this.toInlineCode(it.getTargetType()), it.getTargetModule().getDisplayName())).map(this::toBulletPoint).collect(Collectors.joining("\n"));
        return bullets.isBlank() ? "None" : bullets;
    }

    public String renderHeadline(int i, String modules) {
        return "=".repeat(i) + " " + modules + System.lineSeparator();
    }

    public String renderPlantUmlInclude(String componentsFilename) {
        return "plantuml::" + componentsFilename + "[]" + System.lineSeparator();
    }

    public String renderGeneralInclude(String componentsFilename) {
        return "include::" + componentsFilename + "[]" + System.lineSeparator();
    }
}

