/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.docs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.modulith.docs.DocumentationSource;
import org.springframework.modulith.docs.SpringModulithDocumentationSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Deprecated
enum SpringAutoRestDocsDocumentationSource implements DocumentationSource
{
    INSTANCE;

    private final JavadocReader reader = JavadocReader.createWithSystemProperty();

    @Override
    public Optional<String> getDocumentation(JavaMethod method) {
        return Optional.of(this.reader.resolveMethodComment(method.getOwner().reflect(), method.getName())).filter(it -> !it.isEmpty());
    }

    @Override
    public Optional<String> getDocumentation(JavaClass type) {
        return Optional.of(this.reader.resolveClassComment(type.reflect())).filter(Predicate.not(String::isEmpty));
    }

    static {
        Assert.isTrue((boolean)ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)SpringModulithDocumentationSource.class.getClassLoader()), (String)"Jackson is required on the classpath for Spring Auto RESTDocs generated Javadoc metadata!");
    }

    static class JavadocReader {
        private static final Logger log = LoggerFactory.getLogger(JavadocReader.class);
        private static final String PATH_DELIMITER = ",";
        private static final String JAVADOC_JSON_DIR_PROPERTY = "org.springframework.restdocs.javadocJsonDir";
        private final Map<String, ClassJavadoc> classCache = new ConcurrentHashMap<String, ClassJavadoc>();
        private final ObjectMapper mapper;
        private final List<File> absoluteBaseDirs;

        private JavadocReader(ObjectMapper mapper, List<File> absoluteBaseDirs) {
            this.mapper = mapper;
            this.absoluteBaseDirs = absoluteBaseDirs;
        }

        public static JavadocReader createWithSystemProperty() {
            String jsonDir = System.getProperties().getProperty(JAVADOC_JSON_DIR_PROPERTY);
            if (!StringUtils.hasText((String)jsonDir)) {
                jsonDir = JavadocReader.getDefaultJsonDirectory();
            }
            return new JavadocReader(JavadocReader.objectMapper(), JavadocReader.toAbsoluteDirs(jsonDir));
        }

        private static String getDefaultJsonDirectory() {
            if (new File("pom.xml").exists()) {
                return "target/generated-javadoc-json";
            }
            return "build/generated-javadoc-json";
        }

        static JavadocReader createWith(String javadocJsonDir) {
            return new JavadocReader(JavadocReader.objectMapper(), JavadocReader.toAbsoluteDirs(javadocJsonDir));
        }

        public String resolveMethodComment(Class<?> javaBaseClass, String javaMethodName) {
            return this.resolveCommentFromClassHierarchy(javaBaseClass, classJavadoc -> classJavadoc.getMethodComment(javaMethodName));
        }

        public String resolveClassComment(Class<?> javaBaseClass) {
            return this.classJavadoc(javaBaseClass).getClassComment();
        }

        private ClassJavadoc classJavadoc(Class<?> clazz) {
            String relativePath = this.classToRelativePath(clazz);
            ClassJavadoc classJavadocFromCache = this.classCache.get(relativePath);
            if (classJavadocFromCache != null) {
                return classJavadocFromCache;
            }
            ClassJavadoc classJavadoc = this.readFiles(clazz, relativePath);
            this.classCache.put(relativePath, classJavadoc);
            return classJavadoc;
        }

        private String classToRelativePath(Class<?> clazz) {
            String packageName = clazz.getPackage().getName();
            String packageDir = packageName.replace(".", File.separator);
            String className = clazz.getCanonicalName().replaceAll(packageName + "\\.?", "");
            return new File(packageDir, className + ".json").getPath();
        }

        private ClassJavadoc readFiles(Class<?> clazz, String relativePath) {
            URL url;
            if (this.absoluteBaseDirs.isEmpty()) {
                ClassJavadoc classJavadoc = this.readJson(new File(relativePath));
                if (classJavadoc != null) {
                    return classJavadoc;
                }
            } else {
                for (File dir : this.absoluteBaseDirs) {
                    ClassJavadoc classJavadoc = this.readJson(new File(dir, relativePath));
                    if (classJavadoc == null) continue;
                    return classJavadoc;
                }
            }
            if ((url = this.getClass().getClassLoader().getResource(relativePath)) != null) {
                return this.readJson(url);
            }
            log.debug("No Javadoc found for class {} in any of the found JSON files", (Object)clazz.getCanonicalName());
            return new ClassJavadoc();
        }

        private ClassJavadoc readJson(File docSource) {
            try {
                return (ClassJavadoc)this.mapper.readerFor(ClassJavadoc.class).readValue(docSource);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                log.error("Failed to read file {}", (Object)docSource.getName(), (Object)e);
            }
            return null;
        }

        private ClassJavadoc readJson(URL docSource) {
            try {
                return (ClassJavadoc)this.mapper.readerFor(ClassJavadoc.class).readValue(docSource);
            }
            catch (IOException e) {
                log.error("Failed to read url {}", (Object)docSource, (Object)e);
                return null;
            }
        }

        private static ObjectMapper objectMapper() {
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
            return mapper;
        }

        private static List<File> toAbsoluteDirs(String javadocJsonDirs) {
            ArrayList<File> absoluteDirs = new ArrayList<File>();
            if (StringUtils.hasText((String)javadocJsonDirs)) {
                String[] dirs;
                for (String dir : dirs = javadocJsonDirs.split(PATH_DELIMITER)) {
                    if (!StringUtils.hasText((String)dir)) continue;
                    absoluteDirs.add(new File(dir.trim()).getAbsoluteFile());
                }
            }
            return absoluteDirs;
        }

        private String resolveCommentFromClassHierarchy(Class<?> javaBaseClass, CommentExtractor commentExtractor) {
            String superClassComment;
            String comment = commentExtractor.comment(this.classJavadoc(javaBaseClass));
            if (StringUtils.hasText((String)comment)) {
                return comment;
            }
            if (javaBaseClass.getSuperclass() != null && StringUtils.hasText((String)(superClassComment = this.resolveCommentFromClassHierarchy(javaBaseClass.getSuperclass(), commentExtractor)))) {
                return superClassComment;
            }
            for (Class<?> i : javaBaseClass.getInterfaces()) {
                String interfaceComment = this.resolveCommentFromClassHierarchy(i, commentExtractor);
                if (!StringUtils.hasText((String)interfaceComment)) continue;
                return interfaceComment;
            }
            return "";
        }

        private static interface CommentExtractor {
            public String comment(ClassJavadoc var1);
        }
    }

    static class ClassJavadoc {
        private String comment;
        private Map<String, MethodJavadoc> methods = new HashMap<String, MethodJavadoc>();

        ClassJavadoc() {
        }

        public String getClassComment() {
            return this.comment;
        }

        public String getMethodComment(String methodName) {
            MethodJavadoc methodJavadoc = this.methods.get(methodName);
            if (methodJavadoc != null) {
                return ClassJavadoc.trimToEmpty(methodJavadoc.getComment());
            }
            return "";
        }

        private static String trimToEmpty(@Nullable String source) {
            return source == null ? "" : source.trim();
        }

        static class MethodJavadoc {
            private String comment;
            private Map<String, String> parameters = new HashMap<String, String>();
            private Map<String, String> tags = new HashMap<String, String>();

            MethodJavadoc() {
            }

            public String getComment() {
                return this.comment;
            }

            public String getParameterComment(String parameterName) {
                return this.parameters.get(parameterName);
            }

            public String getTag(String tagName) {
                return this.tags.get(tagName);
            }
        }
    }
}

