/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.amqp;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitMessageOperations;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.modulith.events.EventExternalizationConfiguration;
import org.springframework.modulith.events.RoutingTarget;
import org.springframework.modulith.events.config.EventExternalizationAutoConfiguration;
import org.springframework.modulith.events.support.BrokerRouting;
import org.springframework.modulith.events.support.DelegatingEventExternalizer;

@AutoConfiguration
@AutoConfigureAfter(value={EventExternalizationAutoConfiguration.class})
@ConditionalOnClass(value={RabbitTemplate.class})
@ConditionalOnProperty(name={"spring.modulith.events.externalization.enabled"}, havingValue="true", matchIfMissing=true)
class RabbitEventExternalizerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RabbitEventExternalizerConfiguration.class);

    RabbitEventExternalizerConfiguration() {
    }

    @Bean
    DelegatingEventExternalizer rabbitEventExternalizer(EventExternalizationConfiguration configuration, RabbitMessageOperations operations, BeanFactory factory) {
        logger.debug("Registering domain event externalization to RabbitMQ\u2026");
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver(factory));
        return new DelegatingEventExternalizer(configuration, (target, payload) -> {
            BrokerRouting routing = BrokerRouting.of((RoutingTarget)target, (EvaluationContext)context);
            Map headers = configuration.getHeadersFor(payload);
            operations.convertAndSend(routing.getTarget(payload), routing.getKey(payload), payload, headers);
            return CompletableFuture.completedFuture(null);
        });
    }
}

