/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.function.Supplier;
import org.springframework.modulith.events.core.EventSerializer;
import org.springframework.util.Assert;

class JacksonEventSerializer
implements EventSerializer {
    private final Supplier<ObjectMapper> mapper;

    public JacksonEventSerializer(Supplier<ObjectMapper> mapper) {
        Assert.notNull(mapper, (String)"ObjectMapper must not be null!");
        this.mapper = mapper;
    }

    public Object serialize(Object event) {
        try {
            return this.mapper.get().writeValueAsString(event);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T deserialize(Object serialized, Class<T> type) {
        try {
            return (T)this.mapper.get().readerFor(type).readValue(serialized.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

