/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jackson;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.modulith.events.config.EventSerializationConfigurationExtension;
import org.springframework.modulith.events.core.EventSerializer;
import org.springframework.modulith.events.jackson.JacksonEventSerializer;
import org.springframework.util.Assert;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration
@AutoConfigureBefore(name={"org.springframework.modulith.events.jackson2.Jackson2EventSerializationConfiguration"})
@ConditionalOnClass(value={JsonMapper.class})
@ConditionalOnMissingBean(value={EventSerializer.class})
class JacksonEventSerializationConfiguration
implements EventSerializationConfigurationExtension {
    private final ObjectProvider<JsonMapper> mapper;
    private final ApplicationContext context;

    public JacksonEventSerializationConfiguration(ObjectProvider<JsonMapper> mapper, ApplicationContext context) {
        Assert.notNull(mapper, (String)"ObjectMapper must not be null!");
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null!");
        this.mapper = mapper;
        this.context = context;
    }

    @Bean
    JacksonEventSerializer jacksonEventSerializer() {
        return new JacksonEventSerializer(() -> (JsonMapper)this.mapper.getIfAvailable(() -> this.defaultMapper()));
    }

    private JsonMapper defaultMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).addModules(this.context.getBeansOfType(JacksonModule.class).values())).build();
    }
}

