/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.util.Map;
import java.util.UUID;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.util.Assert;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum DatabaseType {
    HSQLDB("hsqldb"),
    H2("h2"),
    MYSQL("mysql"){

        @Override
        Object uuidToDatabase(UUID id) {
            return id.toString();
        }

        @Override
        UUID databaseToUUID(Object id) {
            return UUID.fromString(id.toString());
        }
    }
    ,
    POSTGRES("postgresql");

    private static final Map<DatabaseDriver, DatabaseType> DATABASE_DRIVER_TO_DATABASE_TYPE_MAP;
    private final String value;

    static DatabaseType from(DatabaseDriver databaseDriver) {
        DatabaseType databaseType = DATABASE_DRIVER_TO_DATABASE_TYPE_MAP.get(databaseDriver);
        if (databaseType == null) {
            throw new IllegalArgumentException("Unsupported database type: " + databaseDriver);
        }
        return databaseType;
    }

    private DatabaseType(String value) {
        this.value = value;
    }

    Object uuidToDatabase(UUID id) {
        return id;
    }

    UUID databaseToUUID(Object id) {
        Assert.isInstanceOf(UUID.class, (Object)id, (String)"Database value not of type UUID!");
        return (UUID)id;
    }

    String getSchemaResourceFilename() {
        return "/schema-" + this.value + ".sql";
    }

    static {
        DATABASE_DRIVER_TO_DATABASE_TYPE_MAP = Map.of(DatabaseDriver.H2, H2, DatabaseDriver.HSQLDB, HSQLDB, DatabaseDriver.POSTGRESQL, POSTGRES, DatabaseDriver.MYSQL, MYSQL);
    }
}

