/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.util.Arrays;
import java.util.UUID;
import org.springframework.util.Assert;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum DatabaseType {
    HSQLDB("hsqldb", "HSQL Database Engine"),
    H2("h2", "H2"),
    MYSQL("mysql", "MySQL"){

        @Override
        Object uuidToDatabase(UUID id) {
            return id.toString();
        }

        @Override
        UUID databaseToUUID(Object id) {
            return UUID.fromString(id.toString());
        }
    }
    ,
    POSTGRES("postgresql", "PostgreSQL");

    private final String value;
    private final String fullName;

    static DatabaseType from(String productName) {
        return Arrays.stream(DatabaseType.values()).filter(it -> it.fullName.equalsIgnoreCase(productName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported database type: " + productName));
    }

    private DatabaseType(String value, String fullName) {
        this.value = value;
        this.fullName = fullName;
    }

    Object uuidToDatabase(UUID id) {
        return id;
    }

    UUID databaseToUUID(Object id) {
        Assert.isInstanceOf(UUID.class, (Object)id, (String)"Database value not of type UUID!");
        return (UUID)id;
    }

    String getSchemaResourceFilename() {
        return "/schema-" + this.value + ".sql";
    }
}

