/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.lang.Nullable;
import org.springframework.modulith.events.core.EventPublicationRepository;
import org.springframework.modulith.events.core.EventSerializer;
import org.springframework.modulith.events.core.PublicationTargetIdentifier;
import org.springframework.modulith.events.core.TargetEventPublication;
import org.springframework.modulith.events.jdbc.DatabaseType;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class JdbcEventPublicationRepository
implements EventPublicationRepository,
BeanClassLoaderAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcEventPublicationRepository.class);
    private static final String SQL_STATEMENT_INSERT = "INSERT INTO EVENT_PUBLICATION (ID, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT)\nVALUES (?, ?, ?, ?, ?)\n";
    private static final String SQL_STATEMENT_FIND_COMPLETED = "SELECT ID, COMPLETION_DATE, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT\nFROM EVENT_PUBLICATION\nWHERE COMPLETION_DATE IS NOT NULL\nORDER BY PUBLICATION_DATE ASC\n";
    private static final String SQL_STATEMENT_FIND_UNCOMPLETED = "SELECT ID, COMPLETION_DATE, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT\nFROM EVENT_PUBLICATION\nWHERE COMPLETION_DATE IS NULL\nORDER BY PUBLICATION_DATE ASC\n";
    private static final String SQL_STATEMENT_FIND_UNCOMPLETED_BEFORE = "SELECT ID, COMPLETION_DATE, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT\nFROM EVENT_PUBLICATION\nWHERE\n\t\tCOMPLETION_DATE IS NULL\n\t\tAND PUBLICATION_DATE < ?\nORDER BY PUBLICATION_DATE ASC\n";
    private static final String SQL_STATEMENT_UPDATE_BY_EVENT_AND_LISTENER_ID = "UPDATE EVENT_PUBLICATION\nSET COMPLETION_DATE = ?\nWHERE\n\t\tLISTENER_ID = ?\n\t\tAND SERIALIZED_EVENT = ?\n";
    private static final String SQL_STATEMENT_FIND_BY_EVENT_AND_LISTENER_ID = "SELECT *\nFROM EVENT_PUBLICATION\nWHERE\n\t\tSERIALIZED_EVENT = ?\n\t\tAND LISTENER_ID = ?\n\t\tAND COMPLETION_DATE IS NULL\nORDER BY PUBLICATION_DATE\n";
    private static final String SQL_STATEMENT_DELETE = "DELETE\nFROM EVENT_PUBLICATION\nWHERE\n\t\tID IN\n";
    private static final String SQL_STATEMENT_DELETE_UNCOMPLETED = "DELETE\nFROM EVENT_PUBLICATION\nWHERE\n\t\tCOMPLETION_DATE IS NOT NULL\n";
    private static final String SQL_STATEMENT_DELETE_UNCOMPLETED_BEFORE = "DELETE\nFROM EVENT_PUBLICATION\nWHERE\n\t\tCOMPLETION_DATE < ?\n";
    private static final int DELETE_BATCH_SIZE = 100;
    private final JdbcOperations operations;
    private final EventSerializer serializer;
    private final DatabaseType databaseType;
    private ClassLoader classLoader;

    public JdbcEventPublicationRepository(JdbcOperations operations, EventSerializer serializer, DatabaseType databaseType) {
        Assert.notNull((Object)operations, (String)"JdbcOperations must not be null!");
        Assert.notNull((Object)serializer, (String)"EventSerializer must not be null!");
        Assert.notNull((Object)((Object)databaseType), (String)"DatabaseType must not be null!");
        this.operations = operations;
        this.serializer = serializer;
        this.databaseType = databaseType;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Transactional
    public TargetEventPublication create(TargetEventPublication publication) {
        String serializedEvent = this.serializeEvent(publication.getEvent());
        this.operations.update(SQL_STATEMENT_INSERT, new Object[]{this.uuidToDatabase(publication.getIdentifier()), publication.getEvent().getClass().getName(), publication.getTargetIdentifier().getValue(), Timestamp.from(publication.getPublicationDate()), serializedEvent});
        return publication;
    }

    @Transactional
    public void markCompleted(Object event, PublicationTargetIdentifier identifier, Instant completionDate) {
        this.operations.update(SQL_STATEMENT_UPDATE_BY_EVENT_AND_LISTENER_ID, new Object[]{Timestamp.from(completionDate), identifier.getValue(), this.serializer.serialize(event)});
    }

    @Transactional(readOnly=true)
    public Optional<TargetEventPublication> findIncompletePublicationsByEventAndTargetIdentifier(Object event, PublicationTargetIdentifier targetIdentifier) {
        List result = (List)this.operations.query(SQL_STATEMENT_FIND_BY_EVENT_AND_LISTENER_ID, this::resultSetToPublications, new Object[]{this.serializeEvent(event), targetIdentifier.getValue()});
        return result == null ? Optional.empty() : result.stream().findFirst();
    }

    public List<TargetEventPublication> findCompletedPublications() {
        List result = (List)this.operations.query(SQL_STATEMENT_FIND_COMPLETED, this::resultSetToPublications);
        return result == null ? Collections.emptyList() : result;
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findIncompletePublications() {
        return (List)this.operations.query(SQL_STATEMENT_FIND_UNCOMPLETED, this::resultSetToPublications);
    }

    public List<TargetEventPublication> findIncompletePublicationsPublishedBefore(Instant instant) {
        List result = (List)this.operations.query(SQL_STATEMENT_FIND_UNCOMPLETED_BEFORE, this::resultSetToPublications, new Object[]{Timestamp.from(instant)});
        return result == null ? Collections.emptyList() : result;
    }

    public void deletePublications(List<UUID> identifiers) {
        List<Object> dbIdentifiers = identifiers.stream().map(this.databaseType::uuidToDatabase).toList();
        JdbcEventPublicationRepository.batch(dbIdentifiers, 100).forEach(it -> this.operations.update(SQL_STATEMENT_DELETE.concat(JdbcEventPublicationRepository.toParameterPlaceholders(((Object[])it).length)), it));
    }

    public void deleteCompletedPublications() {
        this.operations.execute(SQL_STATEMENT_DELETE_UNCOMPLETED);
    }

    public void deleteCompletedPublicationsBefore(Instant instant) {
        Assert.notNull((Object)instant, (String)"Instant must not be null!");
        this.operations.update(SQL_STATEMENT_DELETE_UNCOMPLETED_BEFORE, new Object[]{Timestamp.from(instant)});
    }

    private String serializeEvent(Object event) {
        return this.serializer.serialize(event).toString();
    }

    private List<TargetEventPublication> resultSetToPublications(ResultSet resultSet) throws SQLException {
        ArrayList<TargetEventPublication> result = new ArrayList<TargetEventPublication>();
        while (resultSet.next()) {
            TargetEventPublication publication = this.resultSetToPublication(resultSet);
            if (publication == null) continue;
            result.add(publication);
        }
        return result;
    }

    @Nullable
    private TargetEventPublication resultSetToPublication(ResultSet rs) throws SQLException {
        UUID id = this.getUuidFromResultSet(rs);
        Class<?> eventClass = this.loadClass(id, rs.getString("EVENT_TYPE"));
        if (eventClass == null) {
            return null;
        }
        Timestamp completionDate = rs.getTimestamp("COMPLETION_DATE");
        Instant publicationDate = rs.getTimestamp("PUBLICATION_DATE").toInstant();
        String listenerId = rs.getString("LISTENER_ID");
        String serializedEvent = rs.getString("SERIALIZED_EVENT");
        return new JdbcEventPublication(id, publicationDate, listenerId, serializedEvent, eventClass, this.serializer, completionDate == null ? null : completionDate.toInstant());
    }

    private Object uuidToDatabase(UUID id) {
        return this.databaseType.uuidToDatabase(id);
    }

    private UUID getUuidFromResultSet(ResultSet rs) throws SQLException {
        return this.databaseType.databaseToUUID(rs.getObject("ID"));
    }

    @Nullable
    private Class<?> loadClass(UUID id, String className) {
        try {
            return ClassUtils.forName((String)className, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Event '{}' of unknown type '{}' found", (Object)id, (Object)className);
            return null;
        }
    }

    private static List<Object[]> batch(List<?> input, int batchSize) {
        int inputSize = input.size();
        return IntStream.range(0, (inputSize + batchSize - 1) / batchSize).mapToObj(i -> input.subList(i * batchSize, Math.min((i + 1) * batchSize, inputSize))).map(List::toArray).toList();
    }

    private static String toParameterPlaceholders(int length) {
        return IntStream.range(0, length).mapToObj(__ -> "?").collect(Collectors.joining(", ", "(", ")"));
    }

    private static class JdbcEventPublication
    implements TargetEventPublication {
        private final UUID id;
        private final Instant publicationDate;
        private final String listenerId;
        private final String serializedEvent;
        private final Class<?> eventType;
        private final EventSerializer serializer;
        @Nullable
        private Instant completionDate;

        public JdbcEventPublication(UUID id, Instant publicationDate, String listenerId, String serializedEvent, Class<?> eventType, EventSerializer serializer, @Nullable Instant completionDate) {
            Assert.notNull((Object)id, (String)"Id must not be null!");
            Assert.notNull((Object)publicationDate, (String)"Publication date must not be null!");
            Assert.hasText((String)listenerId, (String)"Listener id must not be null or empty!");
            Assert.hasText((String)serializedEvent, (String)"Serialized event must not be null or empty!");
            Assert.notNull(eventType, (String)"Event type must not be null!");
            Assert.notNull((Object)serializer, (String)"EventSerializer must not be null!");
            this.id = id;
            this.publicationDate = publicationDate;
            this.listenerId = listenerId;
            this.serializedEvent = serializedEvent;
            this.eventType = eventType;
            this.serializer = serializer;
            this.completionDate = completionDate;
        }

        public UUID getIdentifier() {
            return this.id;
        }

        public Object getEvent() {
            return this.serializer.deserialize((Object)this.serializedEvent, this.eventType);
        }

        public PublicationTargetIdentifier getTargetIdentifier() {
            return PublicationTargetIdentifier.of((String)this.listenerId);
        }

        public Instant getPublicationDate() {
            return this.publicationDate;
        }

        public Optional<Instant> getCompletionDate() {
            return Optional.ofNullable(this.completionDate);
        }

        public boolean isPublicationCompleted() {
            return this.completionDate != null;
        }

        public void markCompleted(Instant instant) {
            this.completionDate = instant;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JdbcEventPublication)) {
                return false;
            }
            JdbcEventPublication that = (JdbcEventPublication)obj;
            return Objects.equals(this.completionDate, that.completionDate) && Objects.equals(this.eventType, that.eventType) && Objects.equals(this.id, that.id) && Objects.equals(this.listenerId, that.listenerId) && Objects.equals(this.publicationDate, that.publicationDate) && Objects.equals(this.serializedEvent, that.serializedEvent) && Objects.equals(this.serializer, that.serializer);
        }

        public int hashCode() {
            return Objects.hash(this.completionDate, this.eventType, this.id, this.listenerId, this.publicationDate, this.serializedEvent, this.serializer);
        }
    }
}

