/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.modulith.events.jdbc.DatabaseSchemaLocator;
import org.springframework.modulith.events.jdbc.DatabaseType;
import org.springframework.modulith.events.jdbc.JdbcRepositorySettings;

class DatabaseSchemaInitializer
implements InitializingBean {
    private final DataSource dataSource;
    private final ResourceLoader resourceLoader;
    private final JdbcOperations jdbcOperations;
    private final JdbcRepositorySettings settings;

    DatabaseSchemaInitializer(DataSource dataSource, ResourceLoader resourceLoader, JdbcOperations jdbcOperations, JdbcRepositorySettings settings) {
        this.dataSource = dataSource;
        this.resourceLoader = resourceLoader;
        this.jdbcOperations = jdbcOperations;
        this.settings = settings;
    }

    public void afterPropertiesSet() throws Exception {
        try (Connection connection = this.dataSource.getConnection();){
            boolean useSchema;
            String initialSchema = connection.getSchema();
            String schemaName = this.settings.getSchema();
            DatabaseType databaseType = this.settings.getDatabaseType();
            boolean bl = useSchema = schemaName != null && !schemaName.isEmpty();
            if (useSchema) {
                if (this.eventPublicationTableExists(schemaName)) {
                    return;
                }
                this.jdbcOperations.execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
                this.jdbcOperations.execute(databaseType.getSetSchemaSql(schemaName));
            }
            DatabaseSchemaLocator locator = new DatabaseSchemaLocator(this.resourceLoader);
            ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
            locator.getSchemaResource(this.settings).forEach(arg_0 -> ((ResourceDatabasePopulator)populator).addScript(arg_0));
            populator.execute(this.dataSource);
            if (initialSchema != null && useSchema) {
                this.jdbcOperations.execute(databaseType.getSetSchemaSql(initialSchema));
            }
        }
    }

    private boolean eventPublicationTableExists(String schema) {
        String query = "SELECT COUNT(*)\nFROM information_schema.tables\nWHERE table_schema = ? AND table_name = 'EVENT_PUBLICATION'\n";
        Integer count = (Integer)this.jdbcOperations.queryForObject(query, Integer.class, new Object[]{schema});
        return count != null && count > 0;
    }
}

