/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.ConstructorBinding;
import org.springframework.boot.context.properties.bind.DefaultValue;
import org.springframework.lang.Nullable;
import org.springframework.modulith.events.jdbc.DatabaseType;

@ConfigurationProperties(prefix="spring.modulith.events.jdbc")
class JdbcConfigurationProperties {
    private final SchemaInitialization schemaInitialization;
    private final String schema;

    @ConstructorBinding
    JdbcConfigurationProperties(SchemaInitialization schemaInitialization, @Nullable String schema) {
        this.schemaInitialization = schemaInitialization;
        this.schema = schema;
    }

    public SchemaInitialization getSchemaInitialization() {
        return this.schemaInitialization;
    }

    @Nullable
    public String getSchema() {
        return this.schema;
    }

    void verify(DatabaseType databaseType) {
        if (this.schema != null && !databaseType.isSchemaSupported()) {
            throw new IllegalStateException("Setting the schema name is not supported!");
        }
    }

    static class SchemaInitialization {
        private final boolean enabled;

        @ConstructorBinding
        SchemaInitialization(@DefaultValue(value={"false"}) boolean enabled) {
            this.enabled = enabled;
        }

        boolean isEnabled() {
            return this.enabled;
        }
    }
}

