/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.util.Arrays;
import java.util.UUID;
import org.springframework.util.Assert;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum DatabaseType {
    HSQLDB("hsqldb", "HSQL Database Engine"),
    H2("h2", "H2"),
    MYSQL("mysql", "MySQL"){

        @Override
        Object uuidToDatabase(UUID id) {
            return id.toString();
        }

        @Override
        UUID databaseToUUID(Object id) {
            return UUID.fromString(id.toString());
        }

        @Override
        boolean isSchemaSupported() {
            return false;
        }
    }
    ,
    MARIADB("mariadb", "MariaDB"){

        @Override
        Object uuidToDatabase(UUID id) {
            return id.toString();
        }

        @Override
        UUID databaseToUUID(Object id) {
            return UUID.fromString(id.toString());
        }

        @Override
        boolean isSchemaSupported() {
            return false;
        }
    }
    ,
    POSTGRES("postgresql", "PostgreSQL"),
    MSSQL("sqlserver", "Microsoft SQL Server"){

        @Override
        Object uuidToDatabase(UUID id) {
            return id.toString();
        }

        @Override
        UUID databaseToUUID(Object id) {
            return UUID.fromString(id.toString());
        }

        @Override
        boolean isSchemaSupported() {
            return false;
        }

        @Override
        String getLimitClause(long limit) {
            return " OFFSET 0 ROWS FETCH NEXT " + limit + " ROWS ONLY";
        }
    }
    ,
    ORACLE("oracle", "Oracle"){

        @Override
        Object uuidToDatabase(UUID id) {
            return id.toString();
        }

        @Override
        UUID databaseToUUID(Object id) {
            return UUID.fromString(id.toString());
        }

        @Override
        boolean isSchemaSupported() {
            return false;
        }

        @Override
        String getLimitClause(long limit) {
            return " FETCH FIRST " + limit + " ROWS ONLY";
        }
    };

    static final String SCHEMA_NOT_SUPPORTED = "Setting the schema name is not supported!";
    private final String value;
    private final String fullName;

    static DatabaseType from(String productName) {
        return Arrays.stream(DatabaseType.values()).filter(it -> it.fullName.equalsIgnoreCase(productName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported database type: " + productName));
    }

    private DatabaseType(String value, String fullName) {
        this.value = value;
        this.fullName = fullName;
    }

    Object uuidToDatabase(UUID id) {
        return id;
    }

    UUID databaseToUUID(Object id) {
        Assert.isInstanceOf(UUID.class, (Object)id, (String)"Database value not of type UUID!");
        return (UUID)id;
    }

    String getSchemaResourceFilename(boolean legacy) {
        return this.getSchemaBase(legacy) + ".sql";
    }

    String getArchiveSchemaResourceFilename(boolean legacy) {
        return this.getSchemaBase(legacy) + "-archive.sql";
    }

    String getLimitClause(long limit) {
        return " LIMIT " + limit;
    }

    private String getSchemaBase(boolean legacy) {
        return "/schemas/" + (legacy ? "v1" : "v2") + "/schema-" + this.value;
    }

    boolean isSchemaSupported() {
        return true;
    }

    String getSetSchemaSql(String schema) {
        if (!this.isSchemaSupported()) {
            throw new IllegalArgumentException(SCHEMA_NOT_SUPPORTED);
        }
        return switch (this) {
            case H2, HSQLDB -> "SET SCHEMA " + schema;
            case POSTGRES -> "SET search_path TO " + schema;
            default -> throw new IllegalArgumentException(SCHEMA_NOT_SUPPORTED);
        };
    }
}

