/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.modulith.events.EventPublication;
import org.springframework.modulith.events.core.EventPublicationRepository;
import org.springframework.modulith.events.core.EventSerializer;
import org.springframework.modulith.events.core.PublicationTargetIdentifier;
import org.springframework.modulith.events.core.TargetEventPublication;
import org.springframework.modulith.events.jdbc.JdbcRepositorySettings;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@Transactional
class JdbcEventPublicationRepositoryV2
implements EventPublicationRepository,
BeanClassLoaderAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcEventPublicationRepositoryV2.class);
    private static final String ALL_COLUMNS = "ID, COMPLETION_DATE, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT, STATUS, COMPLETION_ATTEMPTS, LAST_RESUBMISSION_DATE";
    private static final String SQL_STATEMENT_INSERT = "INSERT INTO %s (ID, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT, STATUS, COMPLETION_ATTEMPTS, LAST_RESUBMISSION_DATE)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?)\n";
    private static final String SQL_STATEMENT_FIND_COMPLETED = "SELECT %s\nFROM %s\nWHERE\n\t\tCOMPLETION_DATE IS NOT NULL OR STATUS IS NOT NULL AND STATUS = 'COMPLETED'\nORDER BY PUBLICATION_DATE ASC\n".formatted("ID, COMPLETION_DATE, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT, STATUS, COMPLETION_ATTEMPTS, LAST_RESUBMISSION_DATE", "%s");
    private static final String SQL_STATEMENT_FIND_INCOMPLETE = "SELECT %s\nFROM %s\nWHERE\n\t\tCOMPLETION_DATE IS NULL OR STATUS != 'COMPLETED'\nORDER BY\n\t\tPUBLICATION_DATE ASC\n".formatted("ID, COMPLETION_DATE, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT, STATUS, COMPLETION_ATTEMPTS, LAST_RESUBMISSION_DATE", "%s");
    private static final String SQL_STATEMENT_FIND_INCOMPLETE_PUBLISHED_BEFORE = "SELECT %s\nFROM %s\nWHERE\n\t\t(COMPLETION_DATE IS NULL OR STATUS IS NOT NULL AND STATUS = 'PROCESSING')\n\t\tAND PUBLICATION_DATE < ?\nORDER BY PUBLICATION_DATE ASC\n".formatted("ID, COMPLETION_DATE, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT, STATUS, COMPLETION_ATTEMPTS, LAST_RESUBMISSION_DATE", "%s");
    private static final String SQL_STATEMENT_UPDATE_BY_EVENT_AND_LISTENER_ID = "UPDATE %s\nSET\n\t\tSTATUS = 'COMPLETED',\n\t\tCOMPLETION_DATE = ?\nWHERE\n\t\tLISTENER_ID = ?\n\t\tAND COMPLETION_DATE IS NULL\n\t\tAND SERIALIZED_EVENT = ?\n";
    private static final String SQL_STATEMENT_UPDATE_BY_ID = "UPDATE %s\nSET\n\t\tSTATUS = 'COMPLETED',\n\t\tCOMPLETION_DATE = ?\nWHERE\n\t\tID = ?\n";
    private static final String SQL_STATEMENT_FIND_BY_EVENT_AND_LISTENER_ID = "SELECT *\nFROM %s\nWHERE\n\t\tSERIALIZED_EVENT = ?\n\t\tAND LISTENER_ID = ?\n\t\tAND (COMPLETION_DATE IS NULL OR STATUS = 'FAILED')\nORDER BY PUBLICATION_DATE\n";
    private static final String SQL_STATEMENT_DELETE = "DELETE\nFROM %s\nWHERE\n\t\tID IN\n";
    private static final String SQL_STATEMENT_DELETE_BY_EVENT_AND_LISTENER_ID = "DELETE FROM %s\nWHERE\n\t\tLISTENER_ID = ?\n\t\tAND SERIALIZED_EVENT = ?\n";
    private static final String SQL_STATEMENT_DELETE_BY_ID = "DELETE\nFROM %s\nWHERE\n\t\tID = ?\n";
    private static final String SQL_STATEMENT_DELETE_COMPLETED = "DELETE\nFROM %s\nWHERE\n\t\tCOMPLETION_DATE IS NOT NULL OR STATUS = 'PROCESSING'\n";
    private static final String SQL_STATEMENT_DELETE_COMPLETED_BEFORE = "DELETE\nFROM %s\nWHERE\n\t\tCOMPLETION_DATE < ? AND (STATUS = 'COMPLETED' OR STATUS IS NULL)\n";
    private static final String SQL_STATEMENT_COPY_TO_ARCHIVE_BY_ID = "INSERT INTO %s (ID, LISTENER_ID, EVENT_TYPE, SERIALIZED_EVENT, PUBLICATION_DATE, STATUS, COMPLETION_DATE, COMPLETION_ATTEMPTS, LAST_RESUBMISSION_DATE)\nSELECT ID, LISTENER_ID, EVENT_TYPE, SERIALIZED_EVENT, PUBLICATION_DATE, 'COMPLETED', ?, COMPLETION_ATTEMPTS, LAST_RESUBMISSION_DATE\n \tFROM %s\n \tWHERE ID = ?\n \t  AND NOT EXISTS (SELECT 1 FROM %s WHERE ID = EVENT_PUBLICATION.ID)\n";
    private static final String SQL_STATEMENT_COPY_TO_ARCHIVE_BY_EVENT_AND_LISTENER_ID = "INSERT INTO %s (ID, LISTENER_ID, EVENT_TYPE, SERIALIZED_EVENT, PUBLICATION_DATE, STATUS, COMPLETION_DATE, COMPLETION_ATTEMPTS, LAST_RESUBMISSION_DATE)\nSELECT ID, LISTENER_ID, EVENT_TYPE, SERIALIZED_EVENT, PUBLICATION_DATE, 'COMPLETED', ?, COMPLETION_ATTEMPTS, LAST_RESUBMISSION_DATE\n \tFROM %s\n \tWHERE LISTENER_ID = ?\n\t  AND SERIALIZED_EVENT = ?\n\t  AND NOT EXISTS (SELECT 1 FROM %s WHERE ID = EVENT_PUBLICATION.ID)\n";
    private static final int DELETE_BATCH_SIZE = 100;
    private final JdbcOperations operations;
    private final EventSerializer serializer;
    private final JdbcRepositorySettings settings;
    private @Nullable ClassLoader classLoader;
    private final String sqlStatementInsert;
    private final String sqlStatementFindCompleted;
    private final String sqlStatementFindIncomplete;
    private final String sqlStatementFindUncompletedBefore;
    private final String sqlStatementUpdateByEventAndListenerId;
    private final String sqlStatementUpdateById;
    private final String sqlStatementFindByEventAndListenerId;
    private final String sqlStatementDelete;
    private final String sqlStatementDeleteByEventAndListenerId;
    private final String sqlStatementDeleteById;
    private final String sqlStatementDeleteCompleted;
    private final String sqlStatementDeleteCompletedBefore;
    private final String sqlStatementCopyToArchive;
    private final String sqlStatementCopyToArchiveByEventAndListenerId;
    private final String sqlStatementMarkProcessing;
    private final String sqlStatementMarkFailed;

    private static String getUpdateSql(String table, EventPublication.Status status) {
        return JdbcEventPublicationRepositoryV2.asOneLine("UPDATE %s\nSET\n\t\tSTATUS = '%s'\nWHERE\n\t\tID = ?\n\t\tAND STATUS != '%s'\n".formatted(table, status.name(), status.name()));
    }

    public JdbcEventPublicationRepositoryV2(JdbcOperations operations, EventSerializer serializer, JdbcRepositorySettings settings) {
        Assert.notNull((Object)operations, (String)"JdbcOperations must not be null!");
        Assert.notNull((Object)serializer, (String)"EventSerializer must not be null!");
        Assert.notNull((Object)settings, (String)"DatabaseType must not be null!");
        this.operations = operations;
        this.serializer = serializer;
        this.settings = settings;
        String table = settings.getTable();
        String completedTable = settings.getArchiveTable();
        this.sqlStatementInsert = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_INSERT.formatted(table));
        this.sqlStatementFindCompleted = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_FIND_COMPLETED.formatted(completedTable));
        this.sqlStatementFindIncomplete = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_FIND_INCOMPLETE.formatted(table));
        this.sqlStatementFindUncompletedBefore = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_FIND_INCOMPLETE_PUBLISHED_BEFORE.formatted(table));
        this.sqlStatementUpdateByEventAndListenerId = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_UPDATE_BY_EVENT_AND_LISTENER_ID.formatted(table));
        this.sqlStatementUpdateById = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_UPDATE_BY_ID.formatted(table));
        this.sqlStatementFindByEventAndListenerId = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_FIND_BY_EVENT_AND_LISTENER_ID.formatted(table));
        this.sqlStatementDelete = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_DELETE.formatted(table));
        this.sqlStatementDeleteByEventAndListenerId = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_DELETE_BY_EVENT_AND_LISTENER_ID.formatted(table));
        this.sqlStatementDeleteById = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_DELETE_BY_ID.formatted(table));
        this.sqlStatementDeleteCompleted = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_DELETE_COMPLETED.formatted(completedTable));
        this.sqlStatementDeleteCompletedBefore = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_DELETE_COMPLETED_BEFORE.formatted(completedTable));
        this.sqlStatementCopyToArchive = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_COPY_TO_ARCHIVE_BY_ID.formatted(completedTable, table, completedTable));
        this.sqlStatementCopyToArchiveByEventAndListenerId = JdbcEventPublicationRepositoryV2.asOneLine(SQL_STATEMENT_COPY_TO_ARCHIVE_BY_EVENT_AND_LISTENER_ID.formatted(completedTable, table, completedTable));
        this.sqlStatementMarkProcessing = JdbcEventPublicationRepositoryV2.getUpdateSql(table, EventPublication.Status.PROCESSING);
        this.sqlStatementMarkFailed = JdbcEventPublicationRepositoryV2.getUpdateSql(table, EventPublication.Status.FAILED);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public TargetEventPublication create(TargetEventPublication publication) {
        String serializedEvent = this.serializeEvent(publication.getEvent());
        this.operations.update(this.sqlStatementInsert, new Object[]{this.uuidToDatabase(publication.getIdentifier()), publication.getEvent().getClass().getName(), publication.getTargetIdentifier().getValue(), Timestamp.from(publication.getPublicationDate()), serializedEvent, publication.getStatus().name(), 1, Timestamp.from(publication.getPublicationDate())});
        return publication;
    }

    public void markProcessing(UUID identifier) {
        this.operations.update(this.sqlStatementMarkProcessing, new Object[]{this.uuidToDatabase(identifier)});
    }

    public void markCompleted(Object event, PublicationTargetIdentifier identifier, Instant completionDate) {
        String targetIdentifier = identifier.getValue();
        Object serializedEvent = this.serializer.serialize(event);
        if (this.settings.isDeleteCompletion()) {
            this.operations.update(this.sqlStatementDeleteByEventAndListenerId, new Object[]{targetIdentifier, serializedEvent});
        } else if (this.settings.isArchiveCompletion()) {
            this.operations.update(this.sqlStatementCopyToArchiveByEventAndListenerId, new Object[]{Timestamp.from(completionDate), targetIdentifier, serializedEvent});
            this.operations.update(this.sqlStatementDeleteByEventAndListenerId, new Object[]{targetIdentifier, serializedEvent});
        } else {
            this.operations.update(this.sqlStatementUpdateByEventAndListenerId, new Object[]{Timestamp.from(completionDate), targetIdentifier, serializedEvent});
        }
    }

    public void markCompleted(UUID identifier, Instant completionDate) {
        Object databaseId = this.uuidToDatabase(identifier);
        Timestamp timestamp = Timestamp.from(completionDate);
        if (this.settings.isDeleteCompletion()) {
            this.operations.update(this.sqlStatementDeleteById, new Object[]{databaseId});
        } else if (this.settings.isArchiveCompletion()) {
            this.operations.update(this.sqlStatementCopyToArchive, new Object[]{timestamp, databaseId});
            this.operations.update(this.sqlStatementDeleteById, new Object[]{databaseId});
        } else {
            this.operations.update(this.sqlStatementUpdateById, new Object[]{timestamp, databaseId});
        }
    }

    public void markFailed(UUID identifier) {
        this.operations.update(this.sqlStatementMarkFailed, new Object[]{this.uuidToDatabase(identifier)});
    }

    public boolean markResubmitted(UUID identifier, Instant instant) {
        String sql = JdbcEventPublicationRepositoryV2.asOneLine("UPDATE %s\nSET\n\t\tSTATUS = 'RESUBMITTED',\n\t\tCOMPLETION_ATTEMPTS = COMPLETION_ATTEMPTS + 1,\n\t\tLAST_RESUBMISSION_DATE = ?\nWHERE\n\t\tID = ?\n\t\tAND STATUS != 'RESUBMITTED'\n".formatted(this.settings.getTable()));
        Timestamp timestamp = Timestamp.from(instant);
        Object id = this.uuidToDatabase(identifier);
        int rowsAffected = this.operations.update(sql, new Object[]{timestamp, id});
        return rowsAffected == 1;
    }

    @Transactional(readOnly=true)
    public Optional<TargetEventPublication> findIncompletePublicationsByEventAndTargetIdentifier(Object event, PublicationTargetIdentifier targetIdentifier) {
        List result = (List)this.operations.query(this.sqlStatementFindByEventAndListenerId, this::resultSetToPublications, new Object[]{this.serializeEvent(event), targetIdentifier.getValue()});
        return result == null ? Optional.empty() : result.stream().findFirst();
    }

    public List<TargetEventPublication> findCompletedPublications() {
        List result = (List)this.operations.query(this.sqlStatementFindCompleted, this::resultSetToPublications);
        return result == null ? Collections.emptyList() : result;
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findIncompletePublications() {
        List result = (List)this.operations.query(this.sqlStatementFindIncomplete, this::resultSetToPublications);
        return result == null ? Collections.emptyList() : result;
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findIncompletePublicationsPublishedBefore(Instant instant) {
        List result = (List)this.operations.query(this.sqlStatementFindUncompletedBefore, this::resultSetToPublications, new Object[]{Timestamp.from(instant)});
        return result == null ? Collections.emptyList() : result;
    }

    public void deletePublications(List<UUID> identifiers) {
        List<Object> dbIdentifiers = identifiers.stream().map(this::uuidToDatabase).toList();
        JdbcEventPublicationRepositoryV2.batch(dbIdentifiers, 100).forEach(it -> this.operations.update(this.sqlStatementDelete.concat(JdbcEventPublicationRepositoryV2.toParameterPlaceholders(((Object[])it).length)), it));
    }

    public void deleteCompletedPublications() {
        this.operations.execute(this.sqlStatementDeleteCompleted);
    }

    public void deleteCompletedPublicationsBefore(Instant instant) {
        Assert.notNull((Object)instant, (String)"Instant must not be null!");
        this.operations.update(this.sqlStatementDeleteCompletedBefore, new Object[]{Timestamp.from(instant)});
    }

    public List<TargetEventPublication> findByStatus(EventPublication.Status status) {
        String table = status == EventPublication.Status.COMPLETED && this.settings.isArchiveCompletion() ? this.settings.getArchiveTable() : this.settings.getTable();
        String sql = "SELECT %s FROM %s\n WHERE STATUS = '%s'\n".formatted(ALL_COLUMNS, table, status.name());
        List result = (List)this.operations.query(sql, this::resultSetToPublications);
        return result == null ? Collections.emptyList() : result;
    }

    public int countByStatus(EventPublication.Status status) {
        String table = status == EventPublication.Status.COMPLETED && this.settings.isArchiveCompletion() ? this.settings.getArchiveTable() : this.settings.getTable();
        String sql = JdbcEventPublicationRepositoryV2.asOneLine("SELECT COUNT(ID) FROM %s\n WHERE STATUS = '%s'\n".formatted(table, status.name()));
        Integer result = (Integer)this.operations.queryForObject(sql, Integer.TYPE);
        return result == null ? 0 : result;
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findFailedPublications(EventPublicationRepository.FailedCriteria criteria) {
        List result;
        Object sql = "SELECT %s\n  FROM %s\n WHERE STATUS = 'FAILED' OR (STATUS IS NULL AND COMPLETION_DATE IS NULL)\n".formatted(ALL_COLUMNS, this.settings.getTable());
        Instant instant = criteria.getPublicationDateReference();
        ArrayList<Timestamp> args = new ArrayList<Timestamp>();
        if (instant != null) {
            sql = (String)sql + " AND PUBLICATION_DATE < ?\n";
            args.add(Timestamp.from(instant));
        }
        sql = (String)sql + " ORDER BY PUBLICATION_DATE ASC";
        long itemsToRead = criteria.getMaxItemsToRead();
        if (itemsToRead != -1L) {
            sql = (String)sql + this.settings.getDatabaseType().getLimitClause(itemsToRead);
        }
        return (result = (List)this.operations.query(JdbcEventPublicationRepositoryV2.asOneLine((String)sql), this::resultSetToPublications, args.toArray())) == null ? Collections.emptyList() : result;
    }

    private String serializeEvent(Object event) {
        return this.serializer.serialize(event).toString();
    }

    private List<TargetEventPublication> resultSetToPublications(ResultSet resultSet) throws SQLException {
        ArrayList<TargetEventPublication> result = new ArrayList<TargetEventPublication>();
        while (resultSet.next()) {
            TargetEventPublication publication = this.resultSetToPublication(resultSet);
            if (publication == null) continue;
            result.add(publication);
        }
        return result;
    }

    private @Nullable TargetEventPublication resultSetToPublication(ResultSet rs) throws SQLException {
        UUID id = this.getUuidFromResultSet(rs);
        Class<?> eventClass = this.loadClass(id, rs.getString("EVENT_TYPE"));
        if (eventClass == null) {
            return null;
        }
        Timestamp completionDate = rs.getTimestamp("COMPLETION_DATE");
        Instant publicationDate = rs.getTimestamp("PUBLICATION_DATE").toInstant();
        String listenerId = rs.getString("LISTENER_ID");
        String serializedEvent = rs.getString("SERIALIZED_EVENT");
        EventPublication.Status status = JdbcEventPublicationRepositoryV2.getStatusFrom(rs);
        Instant lastResubmissionDate = rs.getTimestamp("LAST_RESUBMISSION_DATE").toInstant();
        int completionAttempts = rs.getInt("COMPLETION_ATTEMPTS");
        return new JdbcEventPublication(id, publicationDate, listenerId, () -> this.serializer.deserialize((Object)serializedEvent, eventClass), completionDate == null ? null : completionDate.toInstant(), status, lastResubmissionDate, completionAttempts);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EventPublication.Status getStatusFrom(ResultSet rs) {
        try {
            String status = rs.getString("STATUS");
            return status == null ? null : EventPublication.Status.valueOf((String)status);
        }
        catch (SQLException e) {
            return null;
        }
    }

    private Object uuidToDatabase(UUID id) {
        return this.settings.getDatabaseType().uuidToDatabase(id);
    }

    private UUID getUuidFromResultSet(ResultSet rs) throws SQLException {
        return this.settings.getDatabaseType().databaseToUUID(rs.getObject("ID"));
    }

    private @Nullable Class<?> loadClass(UUID id, String className) {
        try {
            return ClassUtils.forName((String)className, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Event '{}' of unknown type '{}' found", (Object)id, (Object)className);
            return null;
        }
    }

    private static List<Object[]> batch(List<?> input, int batchSize) {
        int inputSize = input.size();
        return IntStream.range(0, (inputSize + batchSize - 1) / batchSize).mapToObj(i -> input.subList(i * batchSize, Math.min((i + 1) * batchSize, inputSize))).map(List::toArray).toList();
    }

    private static String toParameterPlaceholders(int length) {
        return IntStream.range(0, length).mapToObj(__ -> "?").collect(Collectors.joining(", ", "(", ")"));
    }

    private static String asOneLine(String string) {
        return string.replace("\n", " ").replace("\t", " ").replaceAll("\\s+", " ").trim();
    }

    private static class JdbcEventPublication
    implements TargetEventPublication {
        private final UUID id;
        private final Instant publicationDate;
        private final String listenerId;
        private final Supplier<Object> eventSupplier;
        private final @Nullable Instant lastResubmissionDate;
        private final int completionAttempts;
        private @Nullable Instant completionDate;
        private @Nullable Object event;
        private EventPublication.Status status;

        public JdbcEventPublication(UUID id, Instant publicationDate, String listenerId, Supplier<Object> event, @Nullable Instant completionDate, // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable EventPublication.Status status, @Nullable Instant lastResubmissionDate, int completionAttempts) {
            Assert.notNull((Object)id, (String)"Id must not be null!");
            Assert.notNull((Object)publicationDate, (String)"Publication date must not be null!");
            Assert.hasText((String)listenerId, (String)"Listener id must not be null or empty!");
            Assert.notNull(event, (String)"Event must not be null!");
            this.id = id;
            this.publicationDate = publicationDate;
            this.listenerId = listenerId;
            this.eventSupplier = event;
            this.completionDate = completionDate;
            this.status = status != null ? status : (completionDate != null ? EventPublication.Status.COMPLETED : EventPublication.Status.PROCESSING);
            this.lastResubmissionDate = lastResubmissionDate;
            this.completionAttempts = completionAttempts;
        }

        public UUID getIdentifier() {
            return this.id;
        }

        public Object getEvent() {
            if (this.event == null) {
                this.event = this.eventSupplier.get();
            }
            return this.event;
        }

        public PublicationTargetIdentifier getTargetIdentifier() {
            return PublicationTargetIdentifier.of((String)this.listenerId);
        }

        public Instant getPublicationDate() {
            return this.publicationDate;
        }

        public Optional<Instant> getCompletionDate() {
            return Optional.ofNullable(this.completionDate);
        }

        public boolean isPublicationCompleted() {
            return this.completionDate != null;
        }

        public void markCompleted(Instant instant) {
            this.completionDate = instant;
            this.status = EventPublication.Status.COMPLETED;
        }

        public EventPublication.Status getStatus() {
            if (this.status != null) {
                return this.status;
            }
            return this.completionDate != null ? EventPublication.Status.COMPLETED : EventPublication.Status.PROCESSING;
        }

        public @Nullable Instant getLastResubmissionDate() {
            return this.lastResubmissionDate;
        }

        public int getCompletionAttempts() {
            return this.completionAttempts;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JdbcEventPublication)) {
                return false;
            }
            JdbcEventPublication that = (JdbcEventPublication)obj;
            return Objects.equals(this.completionDate, that.completionDate) && Objects.equals(this.id, that.id) && Objects.equals(this.listenerId, that.listenerId) && Objects.equals(this.publicationDate, that.publicationDate) && Objects.equals(this.getEvent(), that.getEvent());
        }

        public int hashCode() {
            return Objects.hash(this.completionDate, this.id, this.listenerId, this.publicationDate, this.getEvent());
        }
    }
}

