/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.springframework.modulith.events.jdbc.DatabaseType;
import org.springframework.modulith.events.jdbc.JdbcConfigurationProperties;
import org.springframework.modulith.events.support.CompletionMode;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class JdbcRepositorySettings {
    private final DatabaseType databaseType;
    private final @Nullable String schema;
    private final CompletionMode completionMode;
    private final boolean useLegacyStructure;

    JdbcRepositorySettings(DatabaseType databaseType, CompletionMode completionMode, JdbcConfigurationProperties properties) {
        Assert.notNull((Object)((Object)databaseType), (String)"Database type must not be null!");
        Assert.notNull((Object)completionMode, (String)"Completion mode must not be null!");
        Assert.notNull((Object)properties, (String)"JdbcConfigurationProperties must not be null!");
        this.databaseType = databaseType;
        this.schema = properties.getSchema();
        this.completionMode = completionMode;
        this.useLegacyStructure = properties.isUseLegacyStructure();
        if (this.schema != null && !databaseType.isSchemaSupported()) {
            throw new IllegalStateException("Setting the schema name is not supported!");
        }
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public @Nullable String getSchema() {
        return this.schema;
    }

    public boolean isDeleteCompletion() {
        return this.completionMode == CompletionMode.DELETE;
    }

    public boolean isArchiveCompletion() {
        return this.completionMode == CompletionMode.ARCHIVE;
    }

    public boolean isUpdateCompletion() {
        return this.completionMode == CompletionMode.UPDATE;
    }

    List<Resource> loadSchema(Function<String, Resource> loader) {
        String schemaResourceFilename = this.databaseType.getSchemaResourceFilename(this.useLegacyStructure);
        Resource schemaResource = loader.apply(schemaResourceFilename);
        if (!this.isArchiveCompletion()) {
            return Collections.singletonList(schemaResource);
        }
        String archiveSchemaResourceFilename = this.databaseType.getArchiveSchemaResourceFilename(this.useLegacyStructure);
        return List.of(schemaResource, loader.apply(archiveSchemaResourceFilename));
    }

    SchemaVersion getSchemaVersion() {
        return this.useLegacyStructure ? SchemaVersion.V1 : SchemaVersion.V2;
    }

    String getTable() {
        return ObjectUtils.isEmpty((Object)this.schema) ? "EVENT_PUBLICATION" : this.schema + ".EVENT_PUBLICATION";
    }

    String getArchiveTable() {
        return this.isArchiveCompletion() ? this.getTable() + "_ARCHIVE" : this.getTable();
    }

    static enum SchemaVersion {
        V1,
        V2;

    }
}

