/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import org.springframework.modulith.events.core.EventPublicationRepository;
import org.springframework.modulith.events.core.EventSerializer;
import org.springframework.modulith.events.core.PublicationTargetIdentifier;
import org.springframework.modulith.events.core.TargetEventPublication;
import org.springframework.modulith.events.jpa.JpaEventPublication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional
class JpaEventPublicationRepository
implements EventPublicationRepository {
    private static String BY_EVENT_AND_LISTENER_ID = "select p\nfrom JpaEventPublication p\nwhere\n\tp.serializedEvent = ?1\n\tand p.listenerId = ?2\n\tand p.completionDate is null\n";
    private static String INCOMPLETE = "select p\nfrom JpaEventPublication p\nwhere\n\tp.completionDate is null\norder by\n\tp.publicationDate asc\n";
    private static String INCOMPLETE_BEFORE = "select p\nfrom JpaEventPublication p\nwhere\n\tp.completionDate is null\n\tand p.publicationDate < ?1\norder by\n\tp.publicationDate asc\n";
    private static final String MARK_COMPLETED_BY_EVENT_AND_LISTENER_ID = "update JpaEventPublication p\n   set p.completionDate = ?3\n where p.serializedEvent = ?1\n   and p.listenerId = ?2\n";
    private static final String DELETE = "delete\nfrom JpaEventPublication p\nwhere\n\tp.id in ?1\n";
    private static final String DELETE_COMPLETED = "delete\nfrom JpaEventPublication p\nwhere\n\tp.completionDate is not null\n";
    private static final String DELETE_COMPLETED_BEFORE = "delete\nfrom JpaEventPublication p\nwhere\n\tp.completionDate < ?1\n";
    private static final int DELETE_BATCH_SIZE = 100;
    private final EntityManager entityManager;
    private final EventSerializer serializer;

    public JpaEventPublicationRepository(EntityManager entityManager, EventSerializer serializer) {
        Assert.notNull((Object)entityManager, (String)"EntityManager must not be null!");
        Assert.notNull((Object)serializer, (String)"EventSerializer must not be null!");
        this.entityManager = entityManager;
        this.serializer = serializer;
    }

    public TargetEventPublication create(TargetEventPublication publication) {
        this.entityManager.persist((Object)this.domainToEntity(publication));
        return publication;
    }

    public void markCompleted(Object event, PublicationTargetIdentifier identifier, Instant completionDate) {
        this.entityManager.createQuery(MARK_COMPLETED_BY_EVENT_AND_LISTENER_ID).setParameter(1, (Object)this.serializeEvent(event)).setParameter(2, (Object)identifier.getValue()).setParameter(3, (Object)completionDate).executeUpdate();
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findIncompletePublications() {
        return this.entityManager.createQuery(INCOMPLETE, JpaEventPublication.class).getResultStream().map(this::entityToDomain).toList();
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findIncompletePublicationsPublishedBefore(Instant instant) {
        return this.entityManager.createQuery(INCOMPLETE_BEFORE, JpaEventPublication.class).setParameter(1, (Object)instant).getResultStream().map(this::entityToDomain).toList();
    }

    @Transactional(readOnly=true)
    public Optional<TargetEventPublication> findIncompletePublicationsByEventAndTargetIdentifier(Object event, PublicationTargetIdentifier targetIdentifier) {
        return this.findEntityBySerializedEventAndListenerIdAndCompletionDateNull(event, targetIdentifier).map(this::entityToDomain);
    }

    public void deletePublications(List<UUID> identifiers) {
        JpaEventPublicationRepository.batch(identifiers, 100).forEach(it -> this.entityManager.createQuery(DELETE).setParameter(1, (Object)identifiers).executeUpdate());
    }

    public void deleteCompletedPublications() {
        this.entityManager.createQuery(DELETE_COMPLETED).executeUpdate();
    }

    public void deleteCompletedPublicationsBefore(Instant instant) {
        Assert.notNull((Object)instant, (String)"Instant must not be null!");
        this.entityManager.createQuery(DELETE_COMPLETED_BEFORE).setParameter(1, (Object)instant).executeUpdate();
    }

    private Optional<JpaEventPublication> findEntityBySerializedEventAndListenerIdAndCompletionDateNull(Object event, PublicationTargetIdentifier listenerId) {
        String serializedEvent = this.serializeEvent(event);
        TypedQuery query = this.entityManager.createQuery(BY_EVENT_AND_LISTENER_ID, JpaEventPublication.class).setParameter(1, (Object)serializedEvent).setParameter(2, (Object)listenerId.getValue());
        return query.getResultStream().findFirst();
    }

    private String serializeEvent(Object event) {
        return this.serializer.serialize(event).toString();
    }

    private JpaEventPublication domainToEntity(TargetEventPublication domain) {
        return new JpaEventPublication(domain.getIdentifier(), domain.getPublicationDate(), domain.getTargetIdentifier().getValue(), this.serializeEvent(domain.getEvent()), domain.getEvent().getClass());
    }

    private TargetEventPublication entityToDomain(JpaEventPublication entity) {
        return new JpaEventPublicationAdapter(entity, this.serializer);
    }

    private static <T> List<List<T>> batch(List<T> input, int batchSize) {
        int inputSize = input.size();
        return IntStream.range(0, (inputSize + batchSize - 1) / batchSize).mapToObj(i -> input.subList(i * batchSize, Math.min((i + 1) * batchSize, inputSize))).toList();
    }

    private static class JpaEventPublicationAdapter
    implements TargetEventPublication {
        private final JpaEventPublication publication;
        private final EventSerializer serializer;

        public JpaEventPublicationAdapter(JpaEventPublication publication, EventSerializer serializer) {
            Assert.notNull((Object)publication, (String)"JpaEventPublication must not be null!");
            Assert.notNull((Object)serializer, (String)"EventSerializer must not be null!");
            this.publication = publication;
            this.serializer = serializer;
        }

        public UUID getIdentifier() {
            return this.publication.id;
        }

        public Object getEvent() {
            return this.serializer.deserialize((Object)this.publication.serializedEvent, this.publication.eventType);
        }

        public PublicationTargetIdentifier getTargetIdentifier() {
            return PublicationTargetIdentifier.of((String)this.publication.listenerId);
        }

        public Instant getPublicationDate() {
            return this.publication.publicationDate;
        }

        public Optional<Instant> getCompletionDate() {
            return Optional.ofNullable(this.publication.completionDate);
        }

        public boolean isPublicationCompleted() {
            return this.publication.completionDate != null;
        }

        public void markCompleted(Instant instant) {
            this.publication.completionDate = instant;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JpaEventPublicationAdapter)) {
                return false;
            }
            JpaEventPublicationAdapter that = (JpaEventPublicationAdapter)obj;
            return Objects.equals(this.publication, that.publication) && Objects.equals(this.serializer, that.serializer);
        }

        public int hashCode() {
            return Objects.hash(this.publication, this.serializer);
        }
    }
}

