/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jpa;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.springframework.modulith.events.support.CompletionMode;
import org.springframework.util.Assert;

@MappedSuperclass
abstract class JpaEventPublication {
    @Id
    @Column(length=16)
    final UUID id;
    final Instant publicationDate;
    final String listenerId;
    final String serializedEvent;
    final Class<?> eventType;
    Instant completionDate;

    private JpaEventPublication(UUID id, Instant publicationDate, String listenerId, String serializedEvent, Class<?> eventType) {
        Assert.notNull((Object)id, (String)"Identifier must not be null!");
        Assert.notNull((Object)publicationDate, (String)"Publication date must not be null!");
        Assert.notNull((Object)listenerId, (String)"Listener id must not be null or empty!");
        Assert.notNull((Object)serializedEvent, (String)"Serialized event must not be null or empty!");
        Assert.notNull(eventType, (String)"Event type must not be null!");
        this.id = id;
        this.publicationDate = publicationDate;
        this.listenerId = listenerId;
        this.serializedEvent = serializedEvent;
        this.eventType = eventType;
    }

    protected JpaEventPublication() {
        this.id = null;
        this.publicationDate = null;
        this.listenerId = null;
        this.serializedEvent = null;
        this.eventType = null;
    }

    static JpaEventPublication of(UUID id, Instant publicationDate, String listenerId, String serializedEvent, Class<?> eventType) {
        return new DefaultJpaEventPublication(id, publicationDate, listenerId, serializedEvent, eventType);
    }

    static Class<? extends JpaEventPublication> getIncompleteType() {
        return DefaultJpaEventPublication.class;
    }

    static Class<? extends JpaEventPublication> getCompletedType(CompletionMode mode) {
        return mode == CompletionMode.ARCHIVE ? ArchivedJpaEventPublication.class : DefaultJpaEventPublication.class;
    }

    ArchivedJpaEventPublication archive(Instant instant) {
        ArchivedJpaEventPublication result = new ArchivedJpaEventPublication(this.id, this.publicationDate, this.listenerId, this.serializedEvent, this.eventType);
        result.completionDate = instant;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JpaEventPublication)) {
            return false;
        }
        JpaEventPublication that = (JpaEventPublication)obj;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Entity(name="DefaultJpaEventPublication")
    @Table(name="EVENT_PUBLICATION")
    private static class DefaultJpaEventPublication
    extends JpaEventPublication {
        private DefaultJpaEventPublication(UUID id, Instant publicationDate, String listenerId, String serializedEvent, Class<?> eventType) {
            super(id, publicationDate, listenerId, serializedEvent, eventType);
        }

        DefaultJpaEventPublication() {
        }
    }

    @Entity(name="ArchivedJpaEventPublication")
    @Table(name="EVENT_PUBLICATION_ARCHIVE")
    private static class ArchivedJpaEventPublication
    extends JpaEventPublication {
        private ArchivedJpaEventPublication(UUID id, Instant publicationDate, String listenerId, String serializedEvent, Class<?> eventType) {
            super(id, publicationDate, listenerId, serializedEvent, eventType);
        }

        ArchivedJpaEventPublication() {
        }
    }
}

