/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.kafka;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.modulith.events.EventExternalizationConfiguration;
import org.springframework.modulith.events.RoutingTarget;
import org.springframework.modulith.events.config.EventExternalizationAutoConfiguration;
import org.springframework.modulith.events.support.BrokerRouting;
import org.springframework.modulith.events.support.DelegatingEventExternalizer;

@AutoConfiguration
@AutoConfigureAfter(value={EventExternalizationAutoConfiguration.class})
@ConditionalOnClass(value={KafkaTemplate.class})
@ConditionalOnProperty(name={"spring.modulith.events.externalization.enabled"}, havingValue="true", matchIfMissing=true)
class KafkaEventExternalizerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(KafkaEventExternalizerConfiguration.class);

    KafkaEventExternalizerConfiguration() {
    }

    @Bean
    DelegatingEventExternalizer kafkaEventExternalizer(EventExternalizationConfiguration configuration, KafkaOperations<Object, Object> operations, BeanFactory factory) {
        logger.debug("Registering domain event externalization to Kafka\u2026");
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver(factory));
        return new DelegatingEventExternalizer(configuration, (target, payload) -> {
            BrokerRouting routing = BrokerRouting.of((RoutingTarget)target, (EvaluationContext)context);
            return operations.send(routing.getTarget(), (Object)routing.getKey(payload), payload);
        });
    }
}

