/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.kafka.support.converter.JsonMessageConverter;

@AutoConfiguration
@ConditionalOnClass(value={ObjectMapper.class})
@ConditionalOnProperty(name={"spring.modulith.events.kafka.enable-json"}, havingValue="true", matchIfMissing=true)
@PropertySource(value={"classpath:kafka-json.properties"})
class KafkaJacksonConfiguration {
    KafkaJacksonConfiguration() {
    }

    @Bean
    @ConditionalOnBean(value={ObjectMapper.class})
    @ConditionalOnMissingBean(value={JsonMessageConverter.class})
    JsonMessageConverter jsonMessageConverter(ObjectMapper mapper) {
        return new JsonMessageConverter(mapper);
    }
}

