/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.kafka.autoconfigure.KafkaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.kafka.support.converter.ByteArrayJsonMessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.modulith.events.kafka.KafkaJacksonConfiguration;

@AutoConfiguration
@AutoConfigureBefore(value={KafkaAutoConfiguration.class})
@AutoConfigureAfter(value={KafkaJacksonConfiguration.class})
@ConditionalOnClass(value={ObjectMapper.class})
@ConditionalOnProperty(name={"spring.modulith.events.kafka.enable-json"}, havingValue="true", matchIfMissing=true)
@PropertySource(value={"classpath:kafka-json.properties"})
class KafkaJackson2Configuration {
    KafkaJackson2Configuration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={RecordMessageConverter.class})
    @ConditionalOnClass(value={ObjectMapper.class})
    ByteArrayJsonMessageConverter jackson2jsonMessageConverter(ObjectProvider<ObjectMapper> mapper) {
        return new ByteArrayJsonMessageConverter((ObjectMapper)mapper.getIfUnique(() -> new ObjectMapper()));
    }
}

