/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.kafka;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.kafka.autoconfigure.KafkaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.kafka.support.converter.ByteArrayJacksonJsonMessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.modulith.events.kafka.KafkaJackson2Configuration;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration
@AutoConfigureBefore(value={KafkaAutoConfiguration.class, KafkaJackson2Configuration.class})
@ConditionalOnClass(value={JsonMapper.class})
@ConditionalOnProperty(name={"spring.modulith.events.kafka.enable-json"}, havingValue="true", matchIfMissing=true)
@PropertySource(value={"classpath:kafka-json.properties"})
class KafkaJacksonConfiguration {
    KafkaJacksonConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={RecordMessageConverter.class})
    @ConditionalOnClass(value={JsonMapper.class})
    ByteArrayJacksonJsonMessageConverter jacksonJsonMessageConverter(ObjectProvider<JsonMapper> mapper) {
        return new ByteArrayJacksonJsonMessageConverter((JsonMapper)mapper.getIfUnique(() -> new JsonMapper()));
    }
}

