/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.mongodb;

import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.util.TypeInformation;
import org.springframework.modulith.events.core.EventPublication;
import org.springframework.modulith.events.core.EventPublicationRepository;
import org.springframework.modulith.events.core.PublicationTargetIdentifier;
import org.springframework.modulith.events.mongodb.MongoDbEventPublication;
import org.springframework.util.Assert;

class MongoDbEventPublicationRepository
implements EventPublicationRepository {
    private final MongoTemplate mongoTemplate;

    public MongoDbEventPublicationRepository(MongoTemplate mongoTemplate) {
        Assert.notNull((Object)mongoTemplate, (String)"MongoTemplate must not be null!");
        this.mongoTemplate = mongoTemplate;
    }

    public EventPublication create(EventPublication publication) {
        this.mongoTemplate.save((Object)this.domainToDocument(publication));
        return publication;
    }

    public void markCompleted(Object event, PublicationTargetIdentifier identifier, Instant completionDate) {
        Criteria criteria = this.byEventAndListenerId(event, identifier);
        Update update = Update.update((String)"completionDate", (Object)completionDate);
        this.mongoTemplate.updateFirst(Query.query((CriteriaDefinition)criteria), (UpdateDefinition)update, MongoDbEventPublication.class);
    }

    public List<EventPublication> findIncompletePublications() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"completionDate").isNull()).with(Sort.by((String[])new String[]{"publicationDate"}).ascending());
        return this.mongoTemplate.find(query, MongoDbEventPublication.class).stream().map(this::documentToDomain).toList();
    }

    public Optional<EventPublication> findIncompletePublicationsByEventAndTargetIdentifier(Object event, PublicationTargetIdentifier targetIdentifier) {
        List<MongoDbEventPublication> documents = this.findDocumentsByEventAndTargetIdentifierAndCompletionDateNull(event, targetIdentifier);
        List<EventPublication> results = documents.stream().map(this::documentToDomain).toList();
        return results.isEmpty() ? Optional.empty() : Optional.of(results.get(0));
    }

    public void deleteCompletedPublications() {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"completionDate").ne(null)), MongoDbEventPublication.class);
    }

    public void deleteCompletedPublicationsBefore(Instant instant) {
        Assert.notNull((Object)instant, (String)"Instant must not be null!");
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"completionDate").lt((Object)instant)), MongoDbEventPublication.class);
    }

    private List<MongoDbEventPublication> findDocumentsByEventAndTargetIdentifierAndCompletionDateNull(Object event, PublicationTargetIdentifier targetIdentifier) {
        Criteria criteria = this.byEventAndListenerId(event, targetIdentifier);
        Query query = Query.query((CriteriaDefinition)criteria).with(Sort.by((String[])new String[]{"publicationDate"}).ascending());
        return this.mongoTemplate.find(query, MongoDbEventPublication.class);
    }

    private Criteria byEventAndListenerId(Object event, PublicationTargetIdentifier identifier) {
        Object eventAsMongoType = this.mongoTemplate.getConverter().convertToMongoType(event, TypeInformation.OBJECT);
        return Criteria.where((String)"event").is(eventAsMongoType).and("listenerId").is((Object)identifier.getValue()).and("completionDate").isNull();
    }

    private MongoDbEventPublication domainToDocument(EventPublication publication) {
        return new MongoDbEventPublication(publication.getIdentifier(), publication.getPublicationDate(), publication.getTargetIdentifier().getValue(), publication.getEvent());
    }

    private EventPublication documentToDomain(MongoDbEventPublication document) {
        return new MongoDbEventPublicationAdapter(document);
    }

    private static class MongoDbEventPublicationAdapter
    implements EventPublication {
        private final MongoDbEventPublication publication;

        MongoDbEventPublicationAdapter(MongoDbEventPublication publication) {
            this.publication = publication;
        }

        public UUID getIdentifier() {
            return this.publication.id;
        }

        public Object getEvent() {
            return this.publication.event;
        }

        public PublicationTargetIdentifier getTargetIdentifier() {
            return PublicationTargetIdentifier.of((String)this.publication.listenerId);
        }

        public Instant getPublicationDate() {
            return this.publication.publicationDate;
        }

        public Optional<Instant> getCompletionDate() {
            return Optional.ofNullable(this.publication.completionDate);
        }

        public boolean isPublicationCompleted() {
            return this.publication.completionDate != null;
        }

        public void markCompleted(Instant instant) {
            this.publication.completionDate = instant;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MongoDbEventPublicationAdapter)) {
                return false;
            }
            MongoDbEventPublicationAdapter that = (MongoDbEventPublicationAdapter)obj;
            return Objects.equals(this.publication, that.publication);
        }

        public int hashCode() {
            return Objects.hash(this.publication);
        }
    }
}

