/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.mongodb;

import java.time.Instant;
import java.util.UUID;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@Document(collection="event_publication")
class MongoDbEventPublication {
    final UUID id;
    final Instant publicationDate;
    final String listenerId;
    final Object event;
    @Nullable
    Instant completionDate;

    @PersistenceCreator
    MongoDbEventPublication(UUID id, Instant publicationDate, String listenerId, Object event, @Nullable Instant completionDate) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)publicationDate, (String)"Publication date must not be null!");
        Assert.notNull((Object)listenerId, (String)"Listener id must not be null!");
        Assert.notNull((Object)event, (String)"Event must not be null!");
        this.id = id;
        this.publicationDate = publicationDate;
        this.listenerId = listenerId;
        this.event = event;
        this.completionDate = completionDate;
    }

    MongoDbEventPublication(UUID id, Instant publicationDate, String listenerId, Object event) {
        this(id, publicationDate, listenerId, event, null);
    }

    MongoDbEventPublication markCompleted(Instant instant) {
        Assert.notNull((Object)instant, (String)"Instant must not be null!");
        this.completionDate = instant;
        return this;
    }
}

