/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.mongodb;

import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.util.TypeInformation;
import org.springframework.modulith.events.core.EventPublicationRepository;
import org.springframework.modulith.events.core.PublicationTargetIdentifier;
import org.springframework.modulith.events.core.TargetEventPublication;
import org.springframework.modulith.events.mongodb.MongoDbEventPublication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional
class MongoDbEventPublicationRepository
implements EventPublicationRepository {
    private static final String COMPLETION_DATE = "completionDate";
    private static final String EVENT = "event";
    private static final String ID = "id";
    private static final String LISTENER_ID = "listenerId";
    private static final String PUBLICATION_DATE = "publicationDate";
    private static final Sort DEFAULT_SORT = Sort.by((String[])new String[]{"publicationDate"}).ascending();
    private final MongoTemplate mongoTemplate;

    public MongoDbEventPublicationRepository(MongoTemplate mongoTemplate) {
        Assert.notNull((Object)mongoTemplate, (String)"MongoTemplate must not be null!");
        this.mongoTemplate = mongoTemplate;
    }

    public TargetEventPublication create(TargetEventPublication publication) {
        this.mongoTemplate.save((Object)MongoDbEventPublicationRepository.domainToDocument(publication));
        return publication;
    }

    public void markCompleted(Object event, PublicationTargetIdentifier identifier, Instant completionDate) {
        Update update = Update.update((String)COMPLETION_DATE, (Object)completionDate);
        this.mongoTemplate.findAndModify(this.byEventAndListenerId(event, identifier), (UpdateDefinition)update, MongoDbEventPublication.class);
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findIncompletePublications() {
        return this.readMapped(MongoDbEventPublicationRepository.defaultQuery(Criteria.where((String)COMPLETION_DATE).isNull()));
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findIncompletePublicationsPublishedBefore(Instant instant) {
        return this.readMapped(MongoDbEventPublicationRepository.defaultQuery(Criteria.where((String)COMPLETION_DATE).isNull().and(PUBLICATION_DATE).lt((Object)instant)));
    }

    @Transactional(readOnly=true)
    public Optional<TargetEventPublication> findIncompletePublicationsByEventAndTargetIdentifier(Object event, PublicationTargetIdentifier targetIdentifier) {
        List<TargetEventPublication> results = this.readMapped(this.byEventAndListenerId(event, targetIdentifier));
        return results.isEmpty() ? Optional.empty() : Optional.of(results.get(0));
    }

    public List<TargetEventPublication> findCompletedPublications() {
        return this.readMapped(MongoDbEventPublicationRepository.defaultQuery(Criteria.where((String)COMPLETION_DATE).ne(null)));
    }

    public void deletePublications(List<UUID> identifiers) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)ID).in(identifiers)), MongoDbEventPublication.class);
    }

    public void deleteCompletedPublications() {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)COMPLETION_DATE).ne(null)), MongoDbEventPublication.class);
    }

    public void deleteCompletedPublicationsBefore(Instant instant) {
        Assert.notNull((Object)instant, (String)"Instant must not be null!");
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)COMPLETION_DATE).lt((Object)instant)), MongoDbEventPublication.class);
    }

    private List<TargetEventPublication> readMapped(Query query) {
        return this.mongoTemplate.query(MongoDbEventPublication.class).matching(query).stream().map(MongoDbEventPublicationRepository::documentToDomain).toList();
    }

    private Query byEventAndListenerId(Object event, PublicationTargetIdentifier identifier) {
        Object eventAsMongoType = this.mongoTemplate.getConverter().convertToMongoType(event, TypeInformation.OBJECT);
        return MongoDbEventPublicationRepository.defaultQuery(Criteria.where((String)EVENT).is(eventAsMongoType).and(LISTENER_ID).is((Object)identifier.getValue()).and(COMPLETION_DATE).isNull());
    }

    private static MongoDbEventPublication domainToDocument(TargetEventPublication publication) {
        return new MongoDbEventPublication(publication.getIdentifier(), publication.getPublicationDate(), publication.getTargetIdentifier().getValue(), publication.getEvent());
    }

    private static TargetEventPublication documentToDomain(MongoDbEventPublication document) {
        return new MongoDbEventPublicationAdapter(document);
    }

    private static Query defaultQuery(Criteria criteria) {
        return Query.query((CriteriaDefinition)criteria).with(DEFAULT_SORT);
    }

    private static class MongoDbEventPublicationAdapter
    implements TargetEventPublication {
        private final MongoDbEventPublication publication;

        MongoDbEventPublicationAdapter(MongoDbEventPublication publication) {
            this.publication = publication;
        }

        public UUID getIdentifier() {
            return this.publication.id;
        }

        public Object getEvent() {
            return this.publication.event;
        }

        public PublicationTargetIdentifier getTargetIdentifier() {
            return PublicationTargetIdentifier.of((String)this.publication.listenerId);
        }

        public Instant getPublicationDate() {
            return this.publication.publicationDate;
        }

        public Optional<Instant> getCompletionDate() {
            return Optional.ofNullable(this.publication.completionDate);
        }

        public boolean isPublicationCompleted() {
            return this.publication.completionDate != null;
        }

        public void markCompleted(Instant instant) {
            this.publication.completionDate = instant;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MongoDbEventPublicationAdapter)) {
                return false;
            }
            MongoDbEventPublicationAdapter that = (MongoDbEventPublicationAdapter)obj;
            return Objects.equals(this.publication, that.publication);
        }

        public int hashCode() {
            return Objects.hash(this.publication);
        }
    }
}

