/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.mongodb;

import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bson.Document;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.MergeOperation;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.util.TypeInformation;
import org.springframework.modulith.events.core.EventPublicationRepository;
import org.springframework.modulith.events.core.PublicationTargetIdentifier;
import org.springframework.modulith.events.core.TargetEventPublication;
import org.springframework.modulith.events.mongodb.MongoDbEventPublication;
import org.springframework.modulith.events.support.CompletionMode;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional
class MongoDbEventPublicationRepository
implements EventPublicationRepository {
    private static final String COMPLETION_DATE = "completionDate";
    private static final String EVENT = "event";
    private static final String ID = "id";
    private static final String LISTENER_ID = "listenerId";
    private static final String PUBLICATION_DATE = "publicationDate";
    private static final Sort DEFAULT_SORT = Sort.by((String[])new String[]{"publicationDate"}).ascending();
    static final String ARCHIVE_COLLECTION = "event_publication_archive";
    private final MongoTemplate mongoTemplate;
    private final CompletionMode completionMode;
    private final String collection;
    private final String archiveCollection;

    public MongoDbEventPublicationRepository(MongoTemplate mongoTemplate, CompletionMode completionMode) {
        Assert.notNull((Object)mongoTemplate, (String)"MongoTemplate must not be null!");
        Assert.notNull((Object)completionMode, (String)"Completion mode must not be null!");
        this.mongoTemplate = mongoTemplate;
        this.completionMode = completionMode;
        this.collection = "event_publication";
        this.archiveCollection = completionMode == CompletionMode.ARCHIVE ? ARCHIVE_COLLECTION : this.collection;
    }

    public TargetEventPublication create(TargetEventPublication publication) {
        this.mongoTemplate.save((Object)MongoDbEventPublicationRepository.domainToDocument(publication), this.collection);
        return publication;
    }

    public void markCompleted(Object event, PublicationTargetIdentifier identifier, Instant completionDate) {
        Criteria criteria = this.byEventAndListenerId(event, identifier);
        Query query = MongoDbEventPublicationRepository.defaultQuery(criteria);
        Update update = Update.update((String)COMPLETION_DATE, (Object)completionDate);
        if (this.completionMode == CompletionMode.DELETE) {
            this.mongoTemplate.remove(query, MongoDbEventPublication.class, this.collection);
        } else if (this.completionMode == CompletionMode.ARCHIVE) {
            this.markCompleted(criteria, completionDate);
        } else {
            this.mongoTemplate.findAndModify(query, (UpdateDefinition)update, MongoDbEventPublication.class, this.collection);
        }
    }

    public void markCompleted(UUID identifier, Instant completionDate) {
        Criteria criteria = Criteria.where((String)ID).is((Object)identifier).and(COMPLETION_DATE).isNull();
        Query query = Query.query((CriteriaDefinition)criteria);
        Update update = Update.update((String)COMPLETION_DATE, (Object)completionDate);
        if (this.completionMode == CompletionMode.DELETE) {
            this.mongoTemplate.remove(query, MongoDbEventPublication.class, this.collection);
        } else if (this.completionMode == CompletionMode.ARCHIVE) {
            this.markCompleted(criteria, completionDate);
        } else {
            this.mongoTemplate.findAndModify(query, (UpdateDefinition)update, MongoDbEventPublication.class, this.collection);
        }
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findIncompletePublications() {
        return this.readMapped(MongoDbEventPublicationRepository.defaultQuery(Criteria.where((String)COMPLETION_DATE).isNull()));
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findIncompletePublicationsPublishedBefore(Instant instant) {
        return this.readMapped(MongoDbEventPublicationRepository.defaultQuery(Criteria.where((String)COMPLETION_DATE).isNull().and(PUBLICATION_DATE).lt((Object)instant)));
    }

    @Transactional(readOnly=true)
    public Optional<TargetEventPublication> findIncompletePublicationsByEventAndTargetIdentifier(Object event, PublicationTargetIdentifier targetIdentifier) {
        List<TargetEventPublication> results = this.readMapped(MongoDbEventPublicationRepository.defaultQuery(this.byEventAndListenerId(event, targetIdentifier)));
        return results.isEmpty() ? Optional.empty() : Optional.of(results.get(0));
    }

    public List<TargetEventPublication> findCompletedPublications() {
        return this.readMapped(MongoDbEventPublicationRepository.defaultQuery(Criteria.where((String)COMPLETION_DATE).ne(null)), this.archiveCollection);
    }

    public void deletePublications(List<UUID> identifiers) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)ID).in(identifiers)), MongoDbEventPublication.class, this.collection);
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)ID).in(identifiers)), MongoDbEventPublication.class, this.archiveCollection);
    }

    public void deleteCompletedPublications() {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)COMPLETION_DATE).ne(null)), MongoDbEventPublication.class, this.archiveCollection);
    }

    public void deleteCompletedPublicationsBefore(Instant instant) {
        Assert.notNull((Object)instant, (String)"Instant must not be null!");
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)COMPLETION_DATE).lt((Object)instant)), MongoDbEventPublication.class, this.archiveCollection);
    }

    private List<TargetEventPublication> readMapped(Query query) {
        return this.readMapped(query, this.collection);
    }

    private List<TargetEventPublication> readMapped(Query query, String collection) {
        return this.mongoTemplate.query(MongoDbEventPublication.class).inCollection(collection).matching(query).stream().map(MongoDbEventPublicationRepository::documentToDomain).toList();
    }

    private Criteria byEventAndListenerId(Object event, PublicationTargetIdentifier identifier) {
        Object eventAsMongoType = this.mongoTemplate.getConverter().convertToMongoType(event, TypeInformation.OBJECT);
        return Criteria.where((String)EVENT).is(eventAsMongoType).and(LISTENER_ID).is((Object)identifier.getValue()).and(COMPLETION_DATE).isNull();
    }

    private static MongoDbEventPublication domainToDocument(TargetEventPublication publication) {
        return new MongoDbEventPublication(publication.getIdentifier(), publication.getPublicationDate(), publication.getTargetIdentifier().getValue(), publication.getEvent());
    }

    private static TargetEventPublication documentToDomain(MongoDbEventPublication document) {
        return new MongoDbEventPublicationAdapter(document);
    }

    private static Query defaultQuery(Criteria criteria) {
        return Query.query((CriteriaDefinition)criteria).with(DEFAULT_SORT);
    }

    private void markCompleted(Criteria lookup, Instant now) {
        TypedAggregation aggregation = Aggregation.newAggregation(MongoDbEventPublication.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)lookup), Aggregation.addFields().addFieldWithValue(COMPLETION_DATE, (Object)now).build(), Aggregation.merge().intoCollection(this.archiveCollection).on(new String[]{ID}).whenMatched(MergeOperation.WhenDocumentsMatch.keepExistingDocument()).build()});
        this.mongoTemplate.aggregate(aggregation, this.collection, Document.class).forEach(it -> this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)Fields.UNDERSCORE_ID).is(it.get((Object)Fields.UNDERSCORE_ID))), this.collection));
    }

    private static class MongoDbEventPublicationAdapter
    implements TargetEventPublication {
        private final MongoDbEventPublication publication;

        MongoDbEventPublicationAdapter(MongoDbEventPublication publication) {
            this.publication = publication;
        }

        public UUID getIdentifier() {
            return this.publication.id;
        }

        public Object getEvent() {
            return this.publication.event;
        }

        public PublicationTargetIdentifier getTargetIdentifier() {
            return PublicationTargetIdentifier.of((String)this.publication.listenerId);
        }

        public Instant getPublicationDate() {
            return this.publication.publicationDate;
        }

        public Optional<Instant> getCompletionDate() {
            return Optional.ofNullable(this.publication.completionDate);
        }

        public boolean isPublicationCompleted() {
            return this.publication.completionDate != null;
        }

        public void markCompleted(Instant instant) {
            this.publication.completionDate = instant;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MongoDbEventPublicationAdapter)) {
                return false;
            }
            MongoDbEventPublicationAdapter that = (MongoDbEventPublicationAdapter)obj;
            return Objects.equals(this.publication, that.publication);
        }

        public int hashCode() {
            return Objects.hash(this.publication);
        }
    }

    record IdOnly(@Id UUID id) {
    }
}

