/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.mongodb;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@AutoConfiguration
@AutoConfigureBefore(value={TransactionAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.modulith.events.mongodb.transaction-management.enabled"}, havingValue="true", matchIfMissing=true)
class MongoDbTransactionAutoConfiguration {
    MongoDbTransactionAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    MongoTransactionManager transactionManager(MongoDatabaseFactory factory) {
        return new MongoTransactionManager(factory);
    }

    @Bean
    @ConditionalOnMissingBean
    TransactionTemplate transactionTemplate(PlatformTransactionManager txManager) {
        return new TransactionTemplate(txManager);
    }
}

