/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.junit;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.modulith.junit.diff.ModifiedFile;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class Changes
implements Iterable<Change> {
    public static final Changes NONE = new Changes(Collections.emptySet());
    private final Collection<Change> changes;

    private Changes(Collection<Change> changes) {
        Assert.notNull(changes, (String)"Changes must not be null!");
        this.changes = changes;
    }

    static Changes of(Stream<ModifiedFile> files) {
        Assert.notNull(files, (String)"Modified files must not be null!");
        return files.map(Change::of).collect(Collectors.collectingAndThen(Collectors.toSet(), Changes::new));
    }

    boolean isEmpty() {
        return this.changes.isEmpty();
    }

    Set<String> getChangedClasses() {
        return Changes.filter(this.changes, Change.SourceChange.class, Change.SourceChange::fullyQualifiedClassName).collect(Collectors.toSet());
    }

    boolean hasClassChanges() {
        return !this.getChangedClasses().isEmpty();
    }

    boolean contains(Class<?> type) {
        return this.changes.stream().anyMatch(it -> it.hasOrigin(type.getName()));
    }

    boolean hasBuildResourceChanges() {
        return Changes.filter(this.changes, Change.OtherFileChange.class).anyMatch(Change.OtherFileChange::affectsBuildResource);
    }

    boolean hasClasspathResourceChange() {
        return this.changes.stream().anyMatch(it -> {
            Change.OtherFileChange change;
            return it instanceof Change.OtherFileChange && (change = (Change.OtherFileChange)it).isClasspathResource();
        });
    }

    @Override
    public Iterator<Change> iterator() {
        return this.changes.iterator();
    }

    public String toString() {
        return this.changes.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    private static final <T> Stream<T> filter(Collection<?> source, Class<T> type) {
        return Changes.filter(source, type, Function.identity());
    }

    private static final <T, S> Stream<S> filter(Collection<?> source, Class<T> type, Function<T, S> mapper) {
        return source.stream().filter(type::isInstance).map(type::cast).map(mapper);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface Change {
        public boolean hasOrigin(String var1);

        public static Change of(ModifiedFile file) {
            if (!file.isJavaSource()) {
                return new OtherFileChange(file.path());
            }
            String withoutExtension = StringUtils.stripFilenameExtension((String)file.path());
            int startOfMainDir = withoutExtension.indexOf("src/main/java");
            int startOfTestDir = withoutExtension.indexOf("src/test/java");
            if (startOfTestDir > -1 && (startOfMainDir < 0 || startOfTestDir < startOfMainDir)) {
                String fullyQualifiedClassName = ClassUtils.convertResourcePathToClassName((String)withoutExtension.substring(startOfTestDir + "src/test/java".length() + 1));
                return new JavaTestSourceChange(fullyQualifiedClassName);
            }
            if (startOfMainDir > -1 && (startOfTestDir < 0 || startOfMainDir < startOfTestDir)) {
                String fullyQualifiedClassName = ClassUtils.convertResourcePathToClassName((String)withoutExtension.substring(startOfMainDir + "src/main/java".length() + 1));
                return new JavaSourceChange(fullyQualifiedClassName);
            }
            return new JavaSourceChange(ClassUtils.convertResourcePathToClassName((String)withoutExtension));
        }

        public record OtherFileChange(String path) implements Change
        {
            private static final Collection<String> CLASSPATH_RESOURCES = Set.of("src/main/resources", "src/test/resources");
            private static final Collection<String> BUILD_FILES = Set.of("build.gradle", "build.gradle.kts", "gradle.properties", "settings.gradle", "settings.gradle.kts", "pom.xml");

            public boolean affectsBuildResource() {
                return BUILD_FILES.contains(this.path);
            }

            @Override
            public boolean hasOrigin(String nameOrPath) {
                return this.path.equals(nameOrPath);
            }

            public boolean isClasspathResource() {
                return CLASSPATH_RESOURCES.stream().anyMatch(this.path::startsWith);
            }

            @Override
            public final String toString() {
                return "\ud83d\udcc4 " + this.path;
            }
        }

        public record JavaSourceChange(String fullyQualifiedClassName) implements SourceChange
        {
            private static final String STANDARD_SOURCE_DIRECTORY = "src/main/java";
            private static final String STANDARD_TEST_SOURCE_DIRECTORY = "src/test/java";

            @Override
            public final String toString() {
                return "\u2615 " + this.fullyQualifiedClassName;
            }
        }

        public record JavaTestSourceChange(String fullyQualifiedClassName) implements SourceChange
        {
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static interface SourceChange
        extends Change {
            public String fullyQualifiedClassName();

            @Override
            default public boolean hasOrigin(String nameOrPath) {
                return this.fullyQualifiedClassName().equals(nameOrPath);
            }
        }
    }
}

