/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.junit;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.test.context.AnnotatedClassFinder;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModuleDependencies;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.DependencyType;
import org.springframework.modulith.junit.Changes;
import org.springframework.util.ClassUtils;

class TestExecutionCondition {
    private static final Logger log = LoggerFactory.getLogger(TestExecutionCondition.class);
    private static final AnnotatedClassFinder SPA_CLASS_FINDER = new AnnotatedClassFinder(SpringBootConfiguration.class);
    private final Map<ApplicationModule, ApplicationModuleDependencies> dependencies = new HashMap<ApplicationModule, ApplicationModuleDependencies>();

    TestExecutionCondition() {
    }

    ConditionEvaluationResult evaluate(ConditionContext context) {
        Changes changes = context.changes();
        if (changes.hasClasspathResourceChange()) {
            return TestExecutionCondition.enabled("Some classpath resource changed, running all tests.");
        }
        if (changes.hasBuildResourceChanges()) {
            return TestExecutionCondition.enabled("Build resource changed, running all tests.");
        }
        if (!changes.hasClassChanges()) {
            return TestExecutionCondition.enabled("No source file changes detected.");
        }
        Set<String> changedClasses = changes.getChangedClasses();
        log.trace("Found following changed classes {}", changedClasses);
        Class<?> testClass = context.testClass();
        if (changedClasses.contains(testClass.getName())) {
            return TestExecutionCondition.enabled("Change in test class detected, executing test.");
        }
        Class mainClass = SPA_CLASS_FINDER.findFromClass(testClass);
        if (mainClass == null) {
            return TestExecutionCondition.enabled("Unable to locate SpringBootApplication Class");
        }
        ApplicationModules modules = ApplicationModules.of((Class)mainClass);
        String packageName = ClassUtils.getPackageName(testClass);
        return modules.getModuleForPackage(packageName).map(it -> {
            if (it.isRootModule()) {
                return TestExecutionCondition.enabled("Always executing tests in root modules.");
            }
            ApplicationModuleDependencies dependencies = this.dependencies.computeIfAbsent((ApplicationModule)it, m -> m.getAllDependencies(modules, new DependencyType[0]));
            for (String changedClass : changedClasses) {
                if (it.contains(changedClass)) {
                    return TestExecutionCondition.enabled("Changes detected in module %s, executing test.".formatted(it.getIdentifier()));
                }
                ApplicationModule dependency = dependencies.getModuleByType(changedClass);
                if (dependency == null) continue;
                return TestExecutionCondition.enabled("Changes detected in dependent module %s, executing test.".formatted(dependency.getIdentifier()));
            }
            return TestExecutionCondition.disabled("Test residing in module %s not affected by changes!".formatted(it.getIdentifier()));
        }).orElseGet(() -> TestExecutionCondition.enabled("Test in package %s does not reside in any module!".formatted(packageName)));
    }

    private static ConditionEvaluationResult enabled(String message) {
        return TestExecutionCondition.result(ConditionEvaluationResult::enabled, "\u25b6\ufe0f  " + message);
    }

    private static ConditionEvaluationResult disabled(String message) {
        return TestExecutionCondition.result(ConditionEvaluationResult::disabled, "\u23f8\ufe0f  \ufe0f" + message);
    }

    private static ConditionEvaluationResult result(Function<String, ConditionEvaluationResult> creator, String message) {
        log.info(message);
        return creator.apply(message);
    }

    record ConditionContext(Class<?> testClass, Changes changes) {
    }
}

