/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.junit.diff;

import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.env.PropertyResolver;
import org.springframework.modulith.junit.diff.ModifiedFile;
import org.springframework.modulith.junit.diff.ReferenceCommitDetector;
import org.springframework.modulith.junit.diff.UncommittedChangesDetector;
import org.springframework.modulith.junit.diff.UnpushedCommitsDetector;
import org.springframework.modulith.junit.diff.WorkingDirectoryChangesDetector;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public interface FileModificationDetector {
    public static final String CONFIG_PROPERTY_PREFIX = "spring.modulith.test";
    public static final Logger log = LoggerFactory.getLogger(FileModificationDetector.class);

    public Stream<ModifiedFile> getModifiedFiles();

    public static FileModificationDetector getDetector(PropertyResolver propertyResolver) {
        return WorkingDirectoryChangesDetector.of(FileModificationDetector.getTargetDetector(propertyResolver));
    }

    public static FileModificationDetector getTargetDetector(PropertyResolver propertyResolver) {
        FileModificationDetector fileModificationDetector;
        Assert.notNull((Object)propertyResolver, (String)"PropertyResolver must not be null!");
        String detectorSelector = propertyResolver.getProperty("spring.modulith.test.file-modification-detector");
        String referenceCommit = ReferenceCommitDetector.getReferenceCommitProperty(propertyResolver);
        if (!StringUtils.hasText((String)detectorSelector)) {
            return FileModificationDetector.getDefaultDetector(referenceCommit);
        }
        switch (detectorSelector) {
            case "uncommitted-changes": {
                UncommittedChangesDetector uncommittedChangesDetector;
                fileModificationDetector = uncommittedChangesDetector = UncommittedChangesDetector.INSTANCE;
                break;
            }
            case "reference-commit": {
                ReferenceCommitDetector referenceCommitDetector = new ReferenceCommitDetector(referenceCommit);
                fileModificationDetector = referenceCommitDetector;
                break;
            }
            case "default": {
                FileModificationDetector fileModificationDetector2 = FileModificationDetector.getDefaultDetector(referenceCommit);
                fileModificationDetector = fileModificationDetector2;
                break;
            }
            default: {
                try {
                    Class detectorType = ClassUtils.forName((String)detectorSelector, (ClassLoader)FileModificationDetector.class.getClassLoader());
                    log.info("Found request via property for file modification detector '{}'", (Object)detectorSelector);
                    FileModificationDetector fileModificationDetector3 = (FileModificationDetector)BeanUtils.instantiateClass((Class)detectorType, FileModificationDetector.class);
                    fileModificationDetector = fileModificationDetector3;
                    break;
                }
                catch (ClassNotFoundException | LinkageError o_O) {
                    throw new IllegalStateException(o_O);
                }
            }
        }
        return fileModificationDetector;
    }

    private static FileModificationDetector getDefaultDetector(@Nullable String referenceCommit) {
        if (StringUtils.hasText((String)referenceCommit)) {
            return new ReferenceCommitDetector(referenceCommit);
        }
        log.info("Using default file modification detector (uncommitted and unpushed changes):");
        return () -> Stream.of(UncommittedChangesDetector.INSTANCE, UnpushedCommitsDetector.INSTANCE).flatMap(it -> ((FileModificationDetector)((Object)it)).getModifiedFiles());
    }
}

