/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.junit.diff;

import java.util.Arrays;
import java.util.stream.Stream;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public record ModifiedFile(String path) {
    public boolean isJavaSource() {
        return "java".equalsIgnoreCase(StringUtils.getFilenameExtension((String)this.path));
    }

    public static Stream<ModifiedFile> of(String ... paths) {
        return Arrays.stream(paths).map(ModifiedFile::new);
    }

    ModifiedFile asRelativeTo(String reference) {
        Assert.notNull((Object)reference, (String)"Path must not be null!");
        Assert.isTrue((boolean)reference.startsWith(reference), () -> "Modified file at %s is not located in %s!".formatted(reference, reference));
        return reference.isEmpty() ? this : new ModifiedFile(this.path.substring(reference.length() + 1));
    }
}

