/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.junit.diff;

import java.util.stream.Stream;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.springframework.modulith.junit.diff.FileModificationDetector;
import org.springframework.modulith.junit.diff.JGitUtil;
import org.springframework.modulith.junit.diff.ModifiedFile;

enum UnpushedCommitsDetector implements FileModificationDetector
{
    INSTANCE;


    @Override
    public Stream<ModifiedFile> getModifiedFiles() {
        return (Stream)JGitUtil.withRepository(repo -> {
            String localBranch = repo.getFullBranch();
            String trackingBranch = new BranchConfig((Config)repo.getConfig(), repo.getBranch()).getTrackingBranch();
            return localBranch != null && trackingBranch != null ? JGitUtil.toModifiedFiles(repo, localBranch, trackingBranch) : Stream.empty();
        });
    }
}

