/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.moments.support;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.modulith.moments.DayHasPassed;
import org.springframework.modulith.moments.HourHasPassed;
import org.springframework.modulith.moments.MonthHasPassed;
import org.springframework.modulith.moments.QuarterHasPassed;
import org.springframework.modulith.moments.ShiftedQuarter;
import org.springframework.modulith.moments.WeekHasPassed;
import org.springframework.modulith.moments.YearHasPassed;
import org.springframework.modulith.moments.support.MomentsProperties;
import org.springframework.modulith.moments.support.Now;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.Assert;

public class Moments
implements Now {
    private static final MonthDay DEC_31ST = MonthDay.of(Month.DECEMBER, 31);
    private final Clock clock;
    private final ApplicationEventPublisher events;
    private final MomentsProperties properties;
    private Duration shift = Duration.ZERO;

    public Moments(Clock clock, ApplicationEventPublisher events, MomentsProperties properties) {
        Assert.notNull((Object)clock, (String)"Clock must not be null!");
        Assert.notNull((Object)events, (String)"ApplicationEventPublisher must not be null!");
        Assert.notNull((Object)properties, (String)"MomentsProperties must not be null!");
        this.clock = clock;
        this.events = events;
        this.properties = properties;
    }

    @Scheduled(cron="@hourly")
    void everyHour() {
        if (this.properties.isHourly()) {
            this.emitEventsFor(this.now().minusHours(1L));
        }
    }

    @Scheduled(cron="@daily")
    void everyMidnight() {
        this.emitEventsFor(this.now().toLocalDate().minusDays(1L));
    }

    Moments shiftBy(Duration duration) {
        LocalDateTime before = this.now();
        LocalDateTime after = before.plus(duration);
        this.shift = this.shift.plus(duration);
        if (duration.isNegative()) {
            return this;
        }
        LocalDateTime current = before.truncatedTo(ChronoUnit.HOURS);
        boolean hourly = this.properties.isHourly();
        while (current.isBefore(after.truncatedTo(ChronoUnit.HOURS))) {
            LocalDateTime next;
            LocalDateTime localDateTime = next = hourly ? current.plusHours(1L) : current.plusDays(1L);
            if (hourly) {
                this.emitEventsFor(next);
            }
            if (current.toLocalDate().isBefore(next.toLocalDate())) {
                this.emitEventsFor(current.toLocalDate());
            }
            current = next;
        }
        return this;
    }

    @Override
    public LocalDateTime now() {
        return LocalDateTime.ofInstant(this.instant(), this.properties.getZoneId());
    }

    @Override
    public LocalDate today() {
        return this.now().toLocalDate();
    }

    @Override
    public Instant instant() {
        return this.clock.instant().plus(this.shift);
    }

    private void emitEventsFor(LocalDateTime time) {
        this.events.publishEvent((Object)HourHasPassed.of(time.truncatedTo(ChronoUnit.HOURS)));
    }

    private void emitEventsFor(LocalDate date) {
        ShiftedQuarter quarter;
        this.events.publishEvent((Object)DayHasPassed.of(date));
        Year year = Year.from(date);
        WeekFields weekFields = WeekFields.of(this.properties.getLocale());
        TemporalField field = weekFields.weekOfWeekBasedYear();
        int currentWeek = date.get(field);
        int tomorrowsWeek = date.plusDays(1L).get(field);
        if (tomorrowsWeek != currentWeek) {
            Year eventYear = Year.of(date.get(weekFields.weekBasedYear()));
            this.events.publishEvent((Object)WeekHasPassed.of(eventYear, currentWeek, this.properties.getLocale()));
        }
        if (date.getDayOfMonth() == date.lengthOfMonth()) {
            this.events.publishEvent((Object)MonthHasPassed.of(YearMonth.from(date)));
        }
        if ((quarter = this.properties.getShiftedQuarter(date)).isLastDay(date)) {
            this.events.publishEvent((Object)QuarterHasPassed.of(year, quarter));
        }
        if (MonthDay.from(date).equals(DEC_31ST)) {
            this.events.publishEvent((Object)YearHasPassed.of(year));
        }
    }
}

