/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.moments;

import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.modulith.moments.Quarter;
import org.springframework.util.Assert;

public class ShiftedQuarter {
    private static final MonthDay FIRST_DAY = MonthDay.of(Month.JANUARY, 1);
    private static final MonthDay LAST_DAY = MonthDay.of(Month.DECEMBER, 31);
    private final Quarter quarter;
    private final Month startMonth;

    private ShiftedQuarter(Quarter quarter, Month startMonth) {
        Assert.notNull((Object)((Object)quarter), (String)"Quarter must not be null!");
        Assert.notNull((Object)startMonth, (String)"Start Month must not be null!");
        this.quarter = quarter;
        this.startMonth = startMonth;
    }

    public static ShiftedQuarter of(Quarter quarter, Month startMonth) {
        return new ShiftedQuarter(quarter, startMonth);
    }

    public static ShiftedQuarter of(Quarter quarter) {
        return new ShiftedQuarter(quarter, Month.JANUARY);
    }

    public Quarter getQuarter() {
        return this.quarter;
    }

    public ShiftedQuarter next() {
        return new ShiftedQuarter(this.quarter.next(), this.startMonth);
    }

    public boolean contains(LocalDate date) {
        Assert.notNull((Object)date, (String)"Reference date must not be null!");
        MonthDay shiftedStart = this.getStart();
        MonthDay shiftedEnd = this.getEnd();
        MonthDay reference = MonthDay.from(date);
        Stream<Range> ranges = shiftedEnd.isAfter(shiftedStart) ? Stream.of(new Range(shiftedStart, shiftedEnd)) : Stream.of(new Range(shiftedStart, LAST_DAY), new Range(FIRST_DAY, shiftedEnd));
        return ranges.anyMatch(it -> it.contains(reference));
    }

    public MonthDay getStart() {
        return this.getShifted(this.quarter.getStart());
    }

    public MonthDay getEnd() {
        return this.getShifted(this.quarter.getEnd());
    }

    public boolean isLastDay(LocalDate date) {
        return MonthDay.from(date).equals(this.getEnd());
    }

    public LocalDate getStartDate(Year year) {
        Assert.notNull((Object)year, (String)"Year must not be null!");
        return this.quarter.getStart().atYear(year.getValue()).plusMonths(this.startMonth.getValue() - 1);
    }

    public LocalDate getEndDate(Year year) {
        Assert.notNull((Object)year, (String)"Year must not be null!");
        return this.getStartDate(year).plusMonths(3L).minusDays(1L);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShiftedQuarter)) {
            return false;
        }
        ShiftedQuarter that = (ShiftedQuarter)obj;
        return this.quarter == that.quarter && this.startMonth == that.startMonth;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.quarter, this.startMonth});
    }

    private MonthDay getShifted(MonthDay source) {
        return source.with(source.getMonth().plus(this.startMonth.getValue() - 1));
    }

    private record Range(MonthDay start, MonthDay end) {
        public boolean contains(MonthDay day) {
            boolean isAfterStart = this.start.equals(day) || this.start.isBefore(day);
            boolean isBeforeEnd = this.end.equals(day) || this.end.isAfter(day);
            return isAfterStart && isBeforeEnd;
        }
    }
}

