/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.moments.support;

import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.ConstructorBinding;
import org.springframework.boot.context.properties.bind.DefaultValue;
import org.springframework.modulith.moments.Quarter;
import org.springframework.modulith.moments.ShiftedQuarter;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="spring.modulith.moments")
public class MomentsProperties {
    public static final MomentsProperties DEFAULTS = new MomentsProperties();
    private final Granularity granularity;
    private final ZoneId zoneId;
    private final Locale locale;
    private final boolean enableTimeMachine;
    private final ShiftedQuarters quarters;

    private MomentsProperties() {
        this(null, null, null, null, false);
    }

    @ConstructorBinding
    private MomentsProperties(@DefaultValue(value={"hours"}) @Nullable Granularity granularity, @Nullable ZoneId zoneId, @Nullable Locale locale, @Nullable Month quarterStartMonth, @DefaultValue(value={"false"}) boolean enableTimeMachine) {
        this.granularity = granularity == null ? Granularity.HOURS : granularity;
        this.zoneId = zoneId == null ? ZoneOffset.UTC : zoneId;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.quarters = ShiftedQuarters.of(quarterStartMonth == null ? Month.JANUARY : quarterStartMonth);
        this.enableTimeMachine = enableTimeMachine;
    }

    private MomentsProperties(Granularity granularity, ZoneId zoneId, Locale locale, boolean enableTimeMachine, ShiftedQuarters quarters) {
        Assert.notNull((Object)((Object)granularity), (String)"Granilarity must not be null!");
        Assert.notNull((Object)zoneId, (String)"ZoneId must not be null!");
        Assert.notNull((Object)locale, (String)"Locale must not be null!");
        Assert.notNull((Object)quarters, (String)"ShiftedQuarters must not be null!");
        this.granularity = granularity;
        this.zoneId = zoneId;
        this.locale = locale;
        this.enableTimeMachine = enableTimeMachine;
        this.quarters = quarters;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isEnableTimeMachine() {
        return this.enableTimeMachine;
    }

    boolean isHourly() {
        return Granularity.HOURS.equals((Object)this.granularity);
    }

    public ShiftedQuarter getShiftedQuarter(LocalDate reference) {
        Assert.notNull((Object)reference, (String)"Reference date must not be null!");
        return this.quarters.getCurrent(reference);
    }

    MomentsProperties withGranularity(Granularity granularity) {
        return new MomentsProperties(granularity, this.zoneId, this.locale, this.enableTimeMachine, this.quarters);
    }

    MomentsProperties withZoneId(ZoneId zoneId) {
        return new MomentsProperties(this.granularity, zoneId, this.locale, this.enableTimeMachine, this.quarters);
    }

    MomentsProperties withLocale(Locale locale) {
        return new MomentsProperties(this.granularity, this.zoneId, locale, this.enableTimeMachine, this.quarters);
    }

    static enum Granularity {
        HOURS,
        DAYS;

    }

    private static class ShiftedQuarters {
        private final List<ShiftedQuarter> quarters;

        private ShiftedQuarters(List<ShiftedQuarter> quarters) {
            this.quarters = quarters;
        }

        public ShiftedQuarter getCurrent(LocalDate reference) {
            return this.quarters.stream().filter(it -> it.contains(reference)).findFirst().orElseThrow(() -> new IllegalStateException());
        }

        public static ShiftedQuarters of(Month shift) {
            return new ShiftedQuarters(Arrays.stream(Quarter.values()).map(it -> ShiftedQuarter.of(it, shift)).toList());
        }
    }
}

