/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability;

import com.tngtech.archunit.core.domain.JavaClass;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.framework.Advised;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.ArchitecturallyEvidentType;
import org.springframework.modulith.core.FormatableType;
import org.springframework.modulith.core.SpringBean;
import org.springframework.modulith.observability.ObservedModule;
import org.springframework.modulith.observability.ObservedModuleType;
import org.springframework.util.Assert;

class DefaultObservedModule
implements ObservedModule {
    private final ApplicationModule module;

    DefaultObservedModule(ApplicationModule module) {
        Assert.notNull((Object)module, (String)"ApplicationModule must not be null!");
        this.module = module;
    }

    @Override
    public String getName() {
        return this.module.getName();
    }

    @Override
    public String getDisplayName() {
        return this.module.getDisplayName();
    }

    @Override
    public String getInvokedMethod(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        if (this.module.contains(method.getDeclaringClass())) {
            return DefaultObservedModule.toString(invocation.getMethod(), this.module);
        }
        if (!ProxyMethodInvocation.class.isInstance(invocation)) {
            return DefaultObservedModule.toString(invocation.getMethod(), this.module);
        }
        Advised advised = (Advised)((ProxyMethodInvocation)invocation).getProxy();
        Class targetClass = advised.getTargetClass();
        if (this.module.contains(targetClass)) {
            return DefaultObservedModule.toString(targetClass, method, this.module);
        }
        for (Class type : advised.getProxiedInterfaces()) {
            if (!this.module.contains(type) || !Arrays.asList(type.getMethods()).contains(method)) continue;
            return DefaultObservedModule.toString(type, method, this.module);
        }
        return DefaultObservedModule.toString(invocation.getMethod(), this.module);
    }

    @Override
    public boolean exposes(JavaClass type) {
        Assert.notNull((Object)type, (String)"Type must not be null!");
        return this.module.isExposed(type);
    }

    @Override
    public boolean isObservedModule(ApplicationModule module) {
        Assert.notNull((Object)module, (String)"AppliucationModule must not be null!");
        return this.module.equals((Object)module);
    }

    @Override
    public ObservedModuleType getObservedModuleType(Class<?> type, ApplicationModules modules) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull((Object)modules, (String)"ApplicationModules must not be null!");
        return this.module.getSpringBeans().stream().filter(it -> it.getFullyQualifiedTypeName().equals(type.getName())).map(SpringBean::toArchitecturallyEvidentType).findFirst().map(it -> new ObservedModuleType(modules, this, (ArchitecturallyEvidentType)it)).filter(ObservedModuleType::shouldBeObserved).orElse(null);
    }

    private static String toString(Method method, ApplicationModule module) {
        return DefaultObservedModule.toString(method.getDeclaringClass(), method, module);
    }

    private static String toString(Class<?> type, Method method, ApplicationModule module) {
        String typeName = module.getType(type.getName()).map(FormatableType::of).map(FormatableType::getAbbreviatedFullName).orElseGet(() -> type.getName());
        return typeName + "." + method.getName() + "(\u2026)";
    }
}

