/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability;

import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.modulith.observability.ObservedModule;
import org.springframework.util.Assert;

class ModuleEntryInterceptor
implements MethodInterceptor {
    private static Logger LOGGER = LoggerFactory.getLogger(ModuleEntryInterceptor.class);
    private static Map<String, ModuleEntryInterceptor> CACHE = new HashMap<String, ModuleEntryInterceptor>();
    private final ObservedModule module;
    private final Tracer tracer;

    private ModuleEntryInterceptor(ObservedModule module, Tracer tracer) {
        Assert.notNull((Object)module, (String)"ObservedModule must not be null!");
        Assert.notNull((Object)tracer, (String)"Tracer must not be null!");
        this.module = module;
        this.tracer = tracer;
    }

    public static ModuleEntryInterceptor of(ObservedModule module, Tracer tracer) {
        return CACHE.computeIfAbsent(module.getName(), __ -> new ModuleEntryInterceptor(module, tracer));
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Baggage currentBaggage;
        String moduleName = this.module.getName();
        Span currentSpan = this.tracer.currentSpan();
        if (currentSpan != null && (currentBaggage = this.tracer.getBaggage("org.springframework.modulith.module")) != null && moduleName.equals(currentBaggage.get())) {
            return invocation.proceed();
        }
        String invokedMethod = this.module.getInvokedMethod(invocation);
        LOGGER.trace("Entering {} via {}.", (Object)this.module.getDisplayName(), (Object)invokedMethod);
        Span span = this.tracer.spanBuilder().name(moduleName).tag("module.method", invokedMethod).tag("org.springframework.modulith.module", moduleName).start();
        this.tracer.createBaggage("org.springframework.modulith.module", moduleName);
        try {
            Object object;
            block10: {
                Tracer.SpanInScope ws = this.tracer.withSpan(span);
                try {
                    object = invocation.proceed();
                    if (ws == null) break block10;
                }
                catch (Throwable throwable) {
                    if (ws != null) {
                        try {
                            ws.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ws.close();
            }
            return object;
        }
        finally {
            LOGGER.trace("Leaving {}", (Object)this.module.getDisplayName());
            span.end();
        }
    }
}

