/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability;

import io.micrometer.tracing.Tracer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.observability.DefaultObservedModule;
import org.springframework.modulith.observability.ModuleEntryInterceptor;
import org.springframework.modulith.observability.ModuleTracingSupport;
import org.springframework.modulith.observability.ObservedModule;
import org.springframework.modulith.observability.ObservedModuleType;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;
import org.springframework.util.Assert;

public class ModuleTracingBeanPostProcessor
extends ModuleTracingSupport
implements BeanPostProcessor {
    public static final String MODULE_BAGGAGE_KEY = "org.springframework.modulith.module";
    private final ApplicationModulesRuntime runtime;
    private final Supplier<Tracer> tracer;
    private final Map<String, Advisor> advisors;
    private final ConfigurableListableBeanFactory factory;

    public ModuleTracingBeanPostProcessor(ApplicationModulesRuntime runtime, Supplier<Tracer> tracer, ConfigurableListableBeanFactory factory) {
        Assert.notNull((Object)runtime, (String)"ApplicationModulesRuntime must not be null!");
        Assert.notNull(tracer, (String)"Tracer must not be null!");
        this.runtime = runtime;
        this.tracer = tracer;
        this.advisors = new HashMap<String, Advisor>();
        this.factory = factory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class type = this.runtime.getUserClass(bean, beanName);
        if (!type.isInstance(bean) || this.isInfrastructureBean(beanName) || !this.runtime.isApplicationClass(type)) {
            return bean;
        }
        ApplicationModules modules = this.runtime.get();
        return modules.getModuleByType(type.getName()).map(DefaultObservedModule::new).map(it -> {
            ObservedModuleType moduleType = it.getObservedModuleType(type, modules);
            return moduleType != null ? this.addAdvisor(bean, this.getOrBuildAdvisor((ObservedModule)it, moduleType)) : bean;
        }).orElse(bean);
    }

    private boolean isInfrastructureBean(String beanName) {
        if (!this.factory.containsBean(beanName)) {
            return false;
        }
        if (this.factory.getBeanDefinition(beanName).getRole() == 2) {
            return true;
        }
        return this.factory.findAnnotationOnBean(beanName, ConfigurationProperties.class, false) != null;
    }

    private Advisor getOrBuildAdvisor(ObservedModule module, ObservedModuleType type) {
        return this.advisors.computeIfAbsent(module.getName(), __ -> {
            ModuleEntryInterceptor interceptor = ModuleEntryInterceptor.of(module, this.tracer.get());
            ObservableTypeMethodMatcher matcher = new ObservableTypeMethodMatcher(type);
            ComposablePointcut pointcut = new ComposablePointcut((MethodMatcher)matcher);
            return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)interceptor);
        });
    }

    private static class ObservableTypeMethodMatcher
    extends StaticMethodMatcher {
        private final ObservedModuleType type;

        private ObservableTypeMethodMatcher(ObservedModuleType type) {
            Assert.notNull((Object)type, (String)"ObservableModuleType must not be null!");
            this.type = type;
        }

        public boolean matches(Method method, Class<?> targetClass) {
            return this.type.getMethodsToIntercept().test(method);
        }
    }
}

