/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.aop.TargetClassAware;
import org.springframework.aop.framework.Advised;
import org.springframework.context.annotation.Configuration;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.ArchitecturallyEvidentType;
import org.springframework.modulith.observability.ObservedModule;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class ObservedModuleType {
    private static Collection<Class<?>> IGNORED_TYPES = List.of(Advised.class, TargetClassAware.class);
    private final ApplicationModules modules;
    private final ObservedModule module;
    private final ArchitecturallyEvidentType type;

    ObservedModuleType(ApplicationModules modules, ObservedModule module, ArchitecturallyEvidentType type) {
        Assert.notNull((Object)modules, (String)"ApplicationModules must not be null!");
        Assert.notNull((Object)module, (String)"ObservedModule must not be null!");
        Assert.notNull((Object)type, (String)"ArchitecturallyEvidentType must not be null!");
        this.modules = modules;
        this.module = module;
        this.type = type;
    }

    public boolean shouldBeObserved() {
        if (this.type.getType().isMetaAnnotatedWith(Configuration.class)) {
            return false;
        }
        return this.type.isController() || this.listensToOtherModulesEvents() || this.module.exposes(this.type.getType());
    }

    public Predicate<Method> getMethodsToIntercept() {
        if (!this.type.isEventListener()) {
            return it -> !ReflectionUtils.isObjectMethod((Method)it) && !IGNORED_TYPES.contains(it.getDeclaringClass());
        }
        return candidate -> this.type.getReferenceMethods().map(ArchitecturallyEvidentType.ReferenceMethod::getMethod).anyMatch(it -> it.reflect().equals(candidate));
    }

    private boolean listensToOtherModulesEvents() {
        if (!this.type.isEventListener()) {
            return false;
        }
        return this.type.getReferenceTypes().flatMap(it -> this.modules.getModuleByType(it).map(Stream::of).orElseGet(Stream::empty)).findFirst().map(it -> !this.module.isObservedModule((ApplicationModule)it)).orElse(true);
    }
}

