/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModuleIdentifier;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.ArchitecturallyEvidentType;
import org.springframework.modulith.core.FormattableType;
import org.springframework.modulith.core.SpringBean;
import org.springframework.modulith.observability.ObservedModule;
import org.springframework.modulith.observability.ObservedModuleType;
import org.springframework.util.Assert;

class DefaultObservedModule
implements ObservedModule {
    private final ApplicationModule module;

    DefaultObservedModule(ApplicationModule module) {
        Assert.notNull((Object)module, (String)"ApplicationModule must not be null!");
        this.module = module;
    }

    @Override
    public String getName() {
        return this.getIdentifier().toString();
    }

    @Override
    public ApplicationModuleIdentifier getIdentifier() {
        return this.module.getIdentifier();
    }

    @Override
    public String getDisplayName() {
        return this.module.getDisplayName();
    }

    @Override
    public String getInvokedMethod(MethodInvocation invocation) {
        return DefaultObservedModule.toString(this.findModuleLocalMethod(invocation), this.module);
    }

    @Override
    public boolean exposes(JavaClass type) {
        Assert.notNull((Object)type, (String)"Type must not be null!");
        return this.module.isExposed(type);
    }

    @Override
    public boolean isObservedModule(ApplicationModule module) {
        Assert.notNull((Object)module, (String)"AppliucationModule must not be null!");
        return this.module.equals((Object)module);
    }

    @Override
    public ObservedModuleType getObservedModuleType(Class<?> type, ApplicationModules modules) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull((Object)modules, (String)"ApplicationModules must not be null!");
        return this.module.getSpringBeans().stream().filter(it -> it.getFullyQualifiedTypeName().equals(type.getName())).map(SpringBean::toArchitecturallyEvidentType).findFirst().map(it -> new ObservedModuleType(modules, this, (ArchitecturallyEvidentType)it)).filter(ObservedModuleType::shouldBeObserved).orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEventListenerInvocation(MethodInvocation invocation) {
        Method method = this.findModuleLocalMethod(invocation);
        ArchitecturallyEvidentType type = this.module.getArchitecturallyEvidentType(method.getDeclaringClass());
        if (!type.isEventListener()) return false;
        if (!type.getReferenceMethods().map(ArchitecturallyEvidentType.ReferenceMethod::getMethod).map(JavaMethod::reflect).anyMatch(method::equals)) return false;
        return true;
    }

    private Method findModuleLocalMethod(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        if (this.module.contains(method.getDeclaringClass())) {
            return invocation.getMethod();
        }
        if (!ProxyMethodInvocation.class.isInstance(invocation)) {
            return invocation.getMethod();
        }
        Advised advised = (Advised)((ProxyMethodInvocation)invocation).getProxy();
        Class targetClass = advised.getTargetClass();
        if (this.module.contains(targetClass)) {
            return AopUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
        }
        for (Class type : advised.getProxiedInterfaces()) {
            if (!this.module.contains(type) || !Arrays.asList(type.getMethods()).contains(method)) continue;
            return AopUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
        }
        return invocation.getMethod();
    }

    private static String toString(Method method, ApplicationModule module) {
        Class<?> type = method.getDeclaringClass();
        String typeName = module.getType(type.getName()).map(FormattableType::of).map(FormattableType::getAbbreviatedFullName).orElseGet(() -> type.getName());
        return typeName + "." + method.getName() + "(\u2026)";
    }
}

