/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import java.util.function.Supplier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;
import org.springframework.util.Assert;

public class ModuleEventListener
implements ApplicationListener<ApplicationEvent> {
    private final ApplicationModulesRuntime runtime;
    private final Supplier<Tracer> tracer;

    public ModuleEventListener(ApplicationModulesRuntime runtime, Supplier<Tracer> tracer) {
        Assert.notNull((Object)runtime, (String)"ApplicationModulesRuntime must not be null!");
        Assert.notNull(tracer, (String)"Tracer must not be null!");
        this.runtime = runtime;
        this.tracer = tracer;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (!(event instanceof PayloadApplicationEvent)) {
            return;
        }
        PayloadApplicationEvent payloadEvent = (PayloadApplicationEvent)event;
        Object object = payloadEvent.getPayload();
        Class<?> payloadType = object.getClass();
        if (!this.runtime.isApplicationClass(payloadType)) {
            return;
        }
        ApplicationModule moduleByType = this.runtime.get().getModuleByType(payloadType.getSimpleName()).orElse(null);
        if (moduleByType == null) {
            return;
        }
        Span span = this.tracer.get().currentSpan();
        if (span == null) {
            return;
        }
        span.event("Published " + payloadType.getName());
    }
}

