/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability.support;

import io.micrometer.common.KeyValue;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;
import org.springframework.modulith.core.ApplicationModuleIdentifier;
import org.springframework.modulith.observability.support.DefaultModulithObservationConvention;
import org.springframework.modulith.observability.support.ModulithContext;
import org.springframework.modulith.observability.support.ModulithObservationConvention;
import org.springframework.modulith.observability.support.ModulithObservations;
import org.springframework.modulith.observability.support.ObservedModule;
import org.springframework.util.Assert;

class ModuleEntryInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleEntryInterceptor.class);
    private static Map<ApplicationModuleIdentifier, ModuleEntryInterceptor> CACHE = new HashMap<ApplicationModuleIdentifier, ModuleEntryInterceptor>();
    private static final ModulithObservationConvention DEFAULT = new DefaultModulithObservationConvention();
    private final ObservedModule module;
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ModulithObservationConvention customModulithObservationConvention;
    private final Environment environment;

    private ModuleEntryInterceptor(ObservedModule module, ObservationRegistry observationRegistry, Environment environment) {
        this(module, observationRegistry, null, environment);
    }

    private ModuleEntryInterceptor(ObservedModule module, ObservationRegistry observationRegistry, ModulithObservationConvention custom, Environment environment) {
        Assert.notNull((Object)module, (String)"ObservedModule must not be null!");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null!");
        this.module = module;
        this.observationRegistry = observationRegistry;
        this.customModulithObservationConvention = custom;
        this.environment = environment;
    }

    public static ModuleEntryInterceptor of(ObservedModule module, ObservationRegistry observationRegistry, Environment environment) {
        return ModuleEntryInterceptor.of(module, observationRegistry, null, environment);
    }

    public static ModuleEntryInterceptor of(ObservedModule module, ObservationRegistry observationRegistry, ModulithObservationConvention custom, Environment environment) {
        return CACHE.computeIfAbsent(module.getIdentifier(), __ -> new ModuleEntryInterceptor(module, observationRegistry, custom, environment));
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        ApplicationModuleIdentifier moduleIdentifier = this.module.getIdentifier();
        Observation currentObservation = this.observationRegistry.getCurrentObservation();
        String currentModule = null;
        if (currentObservation != null) {
            KeyValue moduleKey = currentObservation.getContextView().getLowCardinalityKeyValue(ModulithObservations.LowKeys.MODULE_KEY.asString());
            String string = currentModule = moduleKey != null ? moduleKey.getValue() : null;
        }
        if (currentObservation != null && Objects.equals(moduleIdentifier.toString(), currentModule)) {
            return invocation.proceed();
        }
        String invokedMethod = this.module.getInvokedMethod(invocation);
        LOGGER.trace("Entering {} via {}.", (Object)this.module.getDisplayName(), (Object)invokedMethod);
        ModulithContext modulithContext = new ModulithContext(this.module, invocation, this.environment);
        Observation observation = Observation.createNotStarted((ObservationConvention)this.customModulithObservationConvention, (ObservationConvention)DEFAULT, () -> modulithContext, (ObservationRegistry)this.observationRegistry);
        try {
            Object object;
            block13: {
                Observation.Scope scope = observation.start().openScope();
                try {
                    Object proceed = invocation.proceed();
                    observation.event((Observation.Event)ModulithObservations.Events.EVENT_PUBLICATION_SUCCESS);
                    object = proceed;
                    if (scope == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        observation.error((Throwable)ex);
                        observation.event((Observation.Event)ModulithObservations.Events.EVENT_PUBLICATION_FAILURE);
                        throw ex;
                    }
                }
                scope.close();
            }
            return object;
        }
        finally {
            LOGGER.trace("Leaving {}", (Object)this.module.getDisplayName());
            observation.stop();
        }
    }
}

