/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability.support;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import java.lang.reflect.Method;
import org.springframework.modulith.observability.support.ModulithContext;
import org.springframework.modulith.observability.support.ModulithObservationConvention;
import org.springframework.modulith.observability.support.ModulithObservations;

class DefaultModulithObservationConvention
implements ModulithObservationConvention {
    DefaultModulithObservationConvention() {
    }

    public KeyValues getLowCardinalityKeyValues(ModulithContext context) {
        KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{ModulithObservations.LowKeys.MODULE_KEY.withValue(context.getModule().getIdentifier().toString())});
        return this.isEventListener(context) ? keyValues.and(new KeyValue[]{ModulithObservations.LowKeys.INVOCATION_TYPE.withValue("event-listener")}) : keyValues;
    }

    public KeyValues getHighCardinalityKeyValues(ModulithContext context) {
        Method method = context.getInvocation().getMethod();
        return KeyValues.of((KeyValue[])new KeyValue[]{ModulithObservations.HighKeys.MODULE_METHOD.withValue(method.getName())});
    }

    public String getName() {
        return "module.requests";
    }

    public String getContextualName(ModulithContext context) {
        return "[" + context.getApplicationName() + "] " + context.getModule().getDisplayName();
    }

    private boolean isEventListener(ModulithContext context) {
        try {
            return context.getModule().isEventListenerInvocation(context.getInvocation());
        }
        catch (Exception e) {
            return false;
        }
    }
}

