/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability.support;

import com.tngtech.archunit.core.domain.JavaClass;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.aop.TargetClassAware;
import org.springframework.aop.framework.Advised;
import org.springframework.context.annotation.Configuration;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.ArchitecturallyEvidentType;
import org.springframework.modulith.observability.support.ObservedModule;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ObservedModuleType {
    private static final Collection<Class<?>> IGNORED_TYPES = List.of(Advised.class, TargetClassAware.class);
    private static final Predicate<Method> IS_USER_METHOD = it -> !Modifier.isPrivate(it.getModifiers()) && !ReflectionUtils.isObjectMethod((Method)it) && !IGNORED_TYPES.contains(it.getDeclaringClass());
    private static final String MESSAGE_MAPPING_ANNOTATION = "org.springframework.messaging.handler.annotation.MessageMapping";
    private final ApplicationModules modules;
    private final ObservedModule module;
    private final ArchitecturallyEvidentType type;
    private final Predicate<Method> methodsToInterceptFilter;

    ObservedModuleType(ApplicationModules modules, ObservedModule module, ArchitecturallyEvidentType type) {
        Assert.notNull((Object)modules, (String)"ApplicationModules must not be null!");
        Assert.notNull((Object)module, (String)"ObservedModule must not be null!");
        Assert.notNull((Object)type, (String)"ArchitecturallyEvidentType must not be null!");
        this.modules = modules;
        this.module = module;
        this.type = type;
        Predicate<Method> isReferenceMethod = candidate -> type.isEventListener() && type.getReferenceMethods().map(ArchitecturallyEvidentType.ReferenceMethod::getMethod).anyMatch(it -> it.reflect().equals(candidate));
        this.methodsToInterceptFilter = IS_USER_METHOD.or(isReferenceMethod);
    }

    public boolean shouldBeObserved() {
        JavaClass javaType = this.type.getType();
        if (javaType.isMetaAnnotatedWith(Configuration.class)) {
            return false;
        }
        return this.type.isController() || this.listensToOtherModulesEvents() || this.module.exposes(javaType) || ObservedModuleType.hasMethodWithMessageMappingAnnotation(javaType);
    }

    public Predicate<Method> getMethodsToIntercept() {
        return this.methodsToInterceptFilter;
    }

    private boolean listensToOtherModulesEvents() {
        if (!this.type.isEventListener()) {
            return false;
        }
        return this.type.getReferenceTypes().flatMap(it -> this.modules.getModuleByType(it).map(Stream::of).orElseGet(Stream::empty)).findFirst().map(it -> !this.module.isObservedModule((ApplicationModule)it)).orElse(true);
    }

    private static boolean hasMethodWithMessageMappingAnnotation(JavaClass type) {
        Assert.notNull((Object)type, (String)"Type must not be null!");
        return MESSAGE_MAPPING_ANNOTATION != null && type.getMethods().stream().anyMatch(it -> it.isMetaAnnotatedWith(MESSAGE_MAPPING_ANNOTATION));
    }
}

