/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability.support;

import io.micrometer.observation.ObservationRegistry;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.observability.support.DefaultObservedModule;
import org.springframework.modulith.observability.support.ModuleEntryInterceptor;
import org.springframework.modulith.observability.support.ModuleObservabilitySupport;
import org.springframework.modulith.observability.support.ObservedModule;
import org.springframework.modulith.observability.support.ObservedModuleType;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;
import org.springframework.util.Assert;

public class ModuleObservabilityBeanPostProcessor
extends ModuleObservabilitySupport
implements BeanPostProcessor,
Ordered {
    public static final String MODULE_BAGGAGE_KEY = "org.springframework.modulith.module";
    private final ApplicationModulesRuntime runtime;
    private final Supplier<ObservationRegistry> observationRegistry;
    private final Map<String, Advisor> advisors;
    private final ConfigurableListableBeanFactory factory;
    private final Environment environment;

    public ModuleObservabilityBeanPostProcessor(ApplicationModulesRuntime runtime, Supplier<ObservationRegistry> observationRegistry, ConfigurableListableBeanFactory factory, Environment environment) {
        Assert.notNull((Object)runtime, (String)"ApplicationModulesRuntime must not be null!");
        Assert.notNull(observationRegistry, (String)"ObservationRegistry must not be null!");
        Assert.notNull((Object)factory, (String)"BeanFactory must not be null!");
        Assert.notNull((Object)environment, (String)"Environment must not be null!");
        this.runtime = runtime;
        this.observationRegistry = observationRegistry;
        this.advisors = new HashMap<String, Advisor>();
        this.factory = factory;
        this.environment = environment;
    }

    public int getOrder() {
        return 2147483597;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class type = this.runtime.getUserClass(bean, beanName);
        if (!type.isInstance(bean) || this.isInfrastructureBean(beanName) || !this.runtime.isApplicationClass(type)) {
            return bean;
        }
        if (ModuleObservabilityBeanPostProcessor.alreadyAdvised(bean)) {
            return bean;
        }
        ApplicationModules modules = this.runtime.get();
        return modules.getModuleByType(type.getName()).map(DefaultObservedModule::new).map(it -> {
            ObservedModuleType moduleType = it.getObservedModuleType(type, modules);
            return moduleType != null ? this.addAdvisor(bean, this.getOrBuildAdvisor((ObservedModule)it, moduleType)) : bean;
        }).orElse(bean);
    }

    private boolean isInfrastructureBean(String beanName) {
        if (!this.factory.containsBean(beanName)) {
            return false;
        }
        if (this.factory.getBeanDefinition(beanName).getRole() == 2) {
            return true;
        }
        return this.factory.findAnnotationOnBean(beanName, ConfigurationProperties.class, false) != null;
    }

    private Advisor getOrBuildAdvisor(ObservedModule module, ObservedModuleType type) {
        return this.advisors.computeIfAbsent(module.getIdentifier().toString(), __ -> new ApplicationModuleObservingAdvisor(type, ModuleEntryInterceptor.of(module, this.observationRegistry.get(), this.environment)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean alreadyAdvised(Object bean) {
        if (!(bean instanceof Advised)) return false;
        Advised advised = (Advised)bean;
        if (!Arrays.stream(advised.getAdvisors()).anyMatch(ApplicationModuleObservingAdvisor.class::isInstance)) return false;
        return true;
    }

    static class ApplicationModuleObservingAdvisor
    extends DefaultPointcutAdvisor {
        private static final long serialVersionUID = -391548409986032658L;

        public ApplicationModuleObservingAdvisor(ObservedModuleType type, ModuleEntryInterceptor interceptor) {
            super((Pointcut)new ComposablePointcut((MethodMatcher)new ObservableTypeMethodMatcher(type)), (Advice)interceptor);
        }
    }

    private static class ObservableTypeMethodMatcher
    extends StaticMethodMatcher {
        private final ObservedModuleType type;

        private ObservableTypeMethodMatcher(ObservedModuleType type) {
            Assert.notNull((Object)type, (String)"ObservableModuleType must not be null!");
            this.type = type;
        }

        public boolean matches(Method method, Class<?> targetClass) {
            return this.type.getMethodsToIntercept().test(method);
        }
    }
}

